-- strip_emoji/init.lua
-- Replace emojies in messages with GitHub Markdown plain texts
-- Copyright (c) 2026  1F616EMO
-- SPDX-License-Identifier: LGPL-3.0-only

local strip_emoji = {}
_G.strip_emoji = strip_emoji

local MP = core.get_modpath("strip_emoji")
local utf8_codes = modlib.utf8.codes
local utf8_char = modlib.utf8.char

strip_emoji.github_emoji_data = dofile(MP .. "/data/github_emoji_data.lua")

function strip_emoji.process_message(message)
    local result = {}
    local buffer = {}
    local walker = strip_emoji.github_emoji_data

    for _, codepoint in utf8_codes(message) do
        if walker[codepoint] then
            buffer[#buffer + 1] = utf8_char(codepoint)
            walker = walker[codepoint]
        else
            if walker.END then
                result[#result + 1] = ":" .. walker.END .. ":"
                buffer = {}
            else
                for _, char in ipairs(buffer) do
                    result[#result + 1] = char
                end
                buffer = {}
            end
            walker = strip_emoji.github_emoji_data
            if walker[codepoint] then
                buffer[#buffer + 1] = utf8_char(codepoint)
                walker = walker[codepoint]
            else
                result[#result + 1] = utf8_char(codepoint)
            end
        end
    end

    if walker.END then
        result[#result + 1] = ":" .. walker.END .. ":"
    else
        for _, char in ipairs(buffer) do
            result[#result + 1] = char
        end
    end

    return table.concat(result)
end

beerchat.register_callback('before_send_on_channel', function(_, msg)
    msg.message = strip_emoji.process_message(msg.message)
end)
