-- um_interest/init.lua
-- Interest for Unififed Money
--[[
    MIT License

    Copyright (c) 2023 C&C Minetest Server

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
]]

um_interest = {}

local interest_interval = tonumber(minetest.settings:get("um_interest.interest_interval")) or 1000
if interest_interval == 0 then
    minetest.log("warning", "[um_interest] um_interest.interest_interval == 0, exiting.")
    return
end
local online_only = minetest.settings:get_bool("um_interest.online_only", true)
local interest_method = minetest.settings:get("um_interest.interest_method")
if not interest_method or interest_method == "" then
    interest_method = "add"
end
local interest_amount = tonumber(minetest.settings:get("um_interest.interest_amount")) or 5
local exclude_afk = minetest.settings:get_bool("um_interest.exclude_afk", true)
if exclude_afk and not minetest.get_modpath("afk_indicator") then
    minetest.log("warning", "[um_interest] um_interest.exclude_afk == true but afk_indicator not installed, ignoring.")
    exclude_afk = false
end

local timer = 0
minetest.register_globalstep(function(dtime)
    timer = timer + dtime
    if timer < interest_interval then return end
    timer = 0

    local list_players
    if online_only then
        list_players = {}
        for _, p in ipairs(minetest.get_connected_players()) do
            local name = p:get_player_name()
            if not exclude_afk or afk_indicator.get(name) < 300 then
                table.insert(list_players, name)
            end
        end
    else
        list_players = unified_money.list_accounts()
    end

    for _, name in ipairs(list_players) do
        local old_balance = unified_money.get_balance_safe(name)
        local new_balance = old_balance
        if interest_method == "add" then
            new_balance = old_balance + interest_amount
        elseif interest_method == "mul" then
            new_balance = old_balance * interest_amount
        end
        minetest.log("action", string.format("[um_interest] Calculated interest of %s: %d -> %d",
            name, old_balance, new_balance
        ))
        unified_money.set_balance_safe(name, new_balance)
    end
end)
