lootchests.register_lootchest({
    name = "lootchests_default:ocean_chest",
    description = "Ocean Chest",
    spawn_in = {"default:sand", "default:desert_sand", "default:silver_sand"},
    spawn_on = {"default:sand"},
    sounds = default.node_sound_wood_defaults(),
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    ymax = -11,
    ymin = -36,
    spawn_in_rarity = 80,
    spawn_on_rarity = 2750,
    spawn_by = {
        "group:wood", -- sunken ships
        "marinara:sand_with_kelp", -- thick kelp
    },
    num_spawn_by = 2,
    slot_spawn_chance = 55,
    slots = 32,
})

lootchests.register_lootchest({
    name = "lootchests_default:basket",
    description = "Basket",
    tiles = {
        "lootchests_default_basket_top.png",
        "lootchests_default_basket_top.png",
        "lootchests_default_basket_side.png",
    },
    spawn_on = {
        "group:stone",
        "default:dirt",
        "default:dry_dirt",
        "default:dirt_with_grass",
        "default:dirt_with_dry_grass",
        "default:dry_dirt_with_dry_grass",
        "default:dirt_with_coniferous_litter",
        "default:dirt_with_rainforest_litter",
        "default:desert_sand",
        "ethereal:grove_dirt",
        "ethereal:bamboo_dirt",
        "dorwinion:dorwinion_grass",
        "prairie:prairie_dirt_with_grass",
        "nightshade:nightshade_dirt_with_grass",
        "badland:badland_grass",
        "japaneseforest:japanese_dirt_with_grass",
        "naturalbiomes:alderswamp_litter",
        "naturalbiomes:alpine_litter",
        "naturalbiomes:mediterran_litter",
        "naturalbiomes:outback_litter",
        "naturalbiomes:savanna_litter",
        "livingjungle:jungleground",
        "livingjungle:leafyjungleground",
    },
    sounds = default.node_sound_wood_defaults(),
    groups = {snappy = 2, oddly_breakable_by_hand = 2},
    ymax = 31000,
    ymin = -256,
    spawn_on_rarity = 5000,
    spawn_by = {
        "group:tree",
        "group:leaves",
        "group:stone",
        "default:dirt",
        "default:dry_dirt",
        "default:dirt_with_grass",
        "default:dirt_with_dry_grass",
        "default:dry_dirt_with_dry_grass",
        "default:dirt_with_coniferous_litter",
        "default:dirt_with_rainforest_litter",
        "default:desert_sand",
        "ethereal:grove_dirt",
        "ethereal:bamboo_dirt",
        "dorwinion:dorwinion_grass",
        "prairie:prairie_dirt_with_grass",
        "nightshade:nightshade_dirt_with_grass",
        "badland:badland_grass",
        "japaneseforest:japanese_dirt_with_grass",
        "naturalbiomes:alderswamp_litter",
        "naturalbiomes:alpine_litter",
        "naturalbiomes:mediterran_litter",
        "naturalbiomes:outback_litter",
        "naturalbiomes:savanna_litter",
        "livingjungle:jungleground",
        "livingjungle:leafyjungleground",
    },
    num_spawn_by = 9,
    slot_spawn_chance = 40,
    slots = 24,
})

lootchests.register_lootchest({
    name = "lootchests_default:urn",
    description = "Urn",
    tiles = {
        "lootchests_default_urn_top.png",
        "lootchests_default_urn_top.png",
        "lootchests_default_urn_side.png",
    },
    spawn_on = {"group:stone"},
    sounds = default.node_sound_stone_defaults(),
    groups = {cracky = 2, oddly_breakable_by_hand = 2},
    ymax = 0,
    ymin = -4096,
    spawn_on_rarity = 5000,
    spawn_by = {"group:stone"},
    num_spawn_by = 9,
    slot_spawn_chance = 40,
    slots = 24,
})

lootchests.register_lootchest({
    name = "lootchests_default:barrel",
    description = "Barrel",
    tiles = {
        "lootchests_default_barrel_top.png",
        "lootchests_default_barrel_top.png",
        "lootchests_default_barrel_side.png",
    },
    spawn_in = {"default:sand", "default:desert_sand", "default:silver_sand"},
    sounds = default.node_sound_wood_defaults(),
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    ymax = 1,
    ymin = -32,
    spawn_in_rarity = 80,
    slot_spawn_chance = 40,
    slots = 24,
})

lootchests.register_lootchest({
    name = "lootchests_default:stone_chest",
    description = "Ancient Chest",
    tiles = {
        "lootchests_default_stone_chest_top.png",
        "lootchests_default_stone_chest_top.png",
        "lootchests_default_stone_chest_side.png",
        "lootchests_default_stone_chest_side.png",
        "lootchests_default_stone_chest_front.png",
    },
    spawn_in = {"group:stone"},
    spawn_on = {"group:stone"},
    spawn_by = {"group:stone"},
    num_spawn_by = 11,
    sounds = default.node_sound_stone_defaults(),
    groups = {cracky = 2},
    ymax = -256,
    ymin = -31000,
    spawn_in_rarity = 80,
    spawn_on_rarity = 12500,
    slot_spawn_chance = 55,
    slots = 32,
})


