Asuna
=====

Welcome to the vast and vibrant world of Asuna! Journey through a potpourri of natural wonders as you traverse beautiful and breathtaking landscapes. Forests, meadows, jungles, tundras, deserts, swamps, and more await you at every horizon.

This passion project brings together some of the very best biome and world decoration mods that the Minetest community has published. Much of Asuna's beauty is owed to the mod authors who have openly shared the fruits of their hard work and imagination. Asuna stands to honor these authors and their work.

**NOTE: This game is currently a work in progress!** [Bug reports and feature requests are welcome](https://github.com/EmptyStar/asuna/issues).

Features
--------

Asuna provides a wealth of biomes, flora, fauna, and a few other extras. Primary features are highlighted below with the mods they are primarily derived from:

- 60+ biomes to explore ([Everness](https://content.minetest.net/packages/SaKeL/everness/), [Biomes](https://content.minetest.net/packages/Atlante/biomes/), [Ethereal](https://content.minetest.net/packages/TenPlus1/ethereal/), [Wilhelmines Natural Biomes](https://content.minetest.net/packages/Liil/naturalbiomes/), [Wilhelmines Living Jungle](https://content.minetest.net/packages/Liil/livingjungle/), [Wilhelmines Marinara](https://content.minetest.net/packages/Liil/marinara/), [Caverealms Lite](https://content.minetest.net/packages/Shara/caverealms/))
- 100+ flowers, plants, and mushrooms to discover ([Beautiful Flowers](https://content.minetest.net/packages/1faco/beautiflowers/), [Herbs](https://content.minetest.net/packages/Clyde/herbs/), [Plantlife](https://content.minetest.net/packages/mt-mods/plantlife_modpack/), [Baked Clay](https://content.minetest.net/packages/TenPlus1/bakedclay/), [Minetest Game](https://content.minetest.net/packages/Minetest/minetest_game/), and more from the biome mods)
- 30+ farming crops to grow and harvest ([Better Farming](https://content.minetest.net/packages/Atlante/better_farming/), [Minetest Game](https://content.minetest.net/packages/Minetest/minetest_game/))
- 16 different animals to be found in their natural habitats ([Animalia](https://content.minetest.net/packages/ElCeejo/animalia/))
- 80+ decorative stones to unearth ([Too Many Stones](https://content.minetest.net/packages/JoeEnderman/too_many_stones/), [Baked Clay](https://content.minetest.net/packages/TenPlus1/bakedclay/), plus more from biome mods)
- 23 atmospheric background music tracks (curated specifically for Asuna in [asuna_music](https://github.com/EmptyStar/asuna/tree/main/mods/asuna/asuna_music) and played via [Music Modpack](https://content.minetest.net/packages/mt-mods/music_modpack/))

Gameplay
--------

Asuna's features provide a beautiful setting for your own adventures and creations, and a colorful palette with which to create. It's up to you to write your own story, to build your own marvels, and to find your own purpose.

While Asuna is a traditional voxel sandbox game at its core, some provided gameplay features are listed below. For even more gameplay options, check out [ContentDB](https://content.minetest.net/) to find mods that can fulfill all of your wildest dreams.

All gameplay elements listed below are made optional and configurable via `Settings > All Settings > Content: Games > Asuna`.

### Nutrition

Players in the world of Asuna benefit from helpful effects granted by staying well fed. A derivative of the "hunger" concept, Asuna revamps this familiar gameplay mechanic to be strictly beneficial to players in a way that aids in exploration and survival. Players will enjoy the following effects when they have eaten:

- Increased movement speed (up to +25% when full)
- The ability to sprint (+100% movement speed while holding the `aux1` key)
- Health regeneration (chance to recover health every five seconds)
- Resistance to poisonous foods (chance to lose nutrition instead of health)

These effects are most pronounced when a player is fully satiated and will diminish gradually as a player becomes hungry. Hunger will only diminish these effects and cannot hurt players unless starvation is explicitly enabled via game settings (disabled by default). Other settings exist to disable nutrition altogether and to modify how slowly or how quickly players become hungry.

This functionality is implemented using a modified version of the [Stamina](https://content.minetest.net/packages/sofar/stamina/) mod.

### Loot Chests

Players can find caches of useful items hidden throughout the caves and landscapes of Asuna. Loot chests, their contents, and their distribution are dependent on the environment in which they are found.

- **Baskets**: Found next to hills, trees, bushes, and in shallow caves, baskets contain items such as food, grasses, wood, seeds, flowers, and leaves.
- **Urns**: These stone vessels are found at a limited depth in caves and can contain tools, stones, gems, crystals, ores, and some limited food items.
- **Ancient Chests**: These old stone chests are found rarely in caves and contain high quality tools, rare gems, mese crystals, and many exotic items that are otherwise rare in the world.
- **Ocean Chests**: These chests are found in deep ocean amidst dense kelp and near shipwrecks, and they contain a variety of useful items in addition to aquatic decorations.

These chests are implemented by a modified version of [LootChests modpack](https://content.minetest.net/packages/mt-mods/lootchest_modpack/).

### Animals

Asuna is home to a number of wild animals which can be found roaming about their natural habitats. These animals are highly interactive and can be fed, bred, tamed, and hunted. These animals are implemented via the [Animalia](https://content.minetest.net/packages/ElCeejo/animalia/) mod which describes the animals in greater detail.