Asuna
=====

Welcome to the vast and vibrant world of Asuna! Journey through a potpourri of natural wonders as you traverse beautiful and breathtaking landscapes. Forests, meadows, jungles, tundras, deserts, swamps, and more await you at every horizon.

This passion project brings together some of the very best biome and world decoration mods that the Minetest community has published to date. Much of Asuna's beauty is owed to the mod authors who have openly shared the fruits of their hard work and imagination. Asuna stands to honor these authors and their works.

Features
--------

Asuna provides a wealth of biomes, flora, fauna, and a few other extras. Primary features are highlighted below with the mods they are primarily derived from:

- 60+ biomes to explore ([Everness](https://content.minetest.net/packages/SaKeL/everness/), [Biomes](https://content.minetest.net/packages/Atlante/biomes/), [Ethereal](https://content.minetest.net/packages/TenPlus1/ethereal/), [Wilhelmines Natural Biomes](https://content.minetest.net/packages/Liil/naturalbiomes/), [Wilhelmines Living Jungle](https://content.minetest.net/packages/Liil/livingjungle/), [Wilhelmines Marinara](https://content.minetest.net/packages/Liil/marinara/), [Caverealms Lite](https://content.minetest.net/packages/Shara/caverealms/))
- 100+ flowers, plants, and mushrooms to discover ([Beautiful Flowers](https://content.minetest.net/packages/1faco/beautiflowers/), [Herbs](https://content.minetest.net/packages/Clyde/herbs/), [Plantlife](https://content.minetest.net/packages/mt-mods/plantlife_modpack/), [Baked Clay](https://content.minetest.net/packages/TenPlus1/bakedclay/), [Minetest Game](https://content.minetest.net/packages/Minetest/minetest_game/), and more from the biome mods)
- 30+ farming crops to grow and harvest ([X Farming](https://content.minetest.net/packages/SaKeL/x_farming/), [Farming Redo](https://content.minetest.net/packages/TenPlus1/farming/))
- 27 different animals and creatures to be found in their natural habitats ([Animalia](https://content.minetest.net/packages/ElCeejo/animalia/), [Living Slimes](https://content.luanti.org/packages/EmptyStar/livingslimes/))
- 80+ decorative stones to unearth ([Too Many Stones](https://content.minetest.net/packages/JoeEnderman/too_many_stones/), [Baked Clay](https://content.minetest.net/packages/TenPlus1/bakedclay/), plus more from biome mods)
- 47 unique achievements to unlock ([Awards](https://content.minetest.net/packages/rubenwardy/awards/), [Asuna Awards](https://github.com/asuna-mt/asuna_game_mods/tree/asuna/asuna_awards))
- 31 atmospheric background music tracks (curated specifically for Asuna in [asuna_core](https://github.com/asuna-mt/asuna_game_mods/tree/asuna/asuna_core) and played via [Music Modpack](https://content.minetest.net/packages/mt-mods/music_modpack/))

Content
-------

Asuna's features provide a beautiful setting for your own adventures and creations and a colorful palette with which to create. It's largely up to you to write your own story, to build your own marvels, and to find your own purpose.

That said, Asuna provides a number of built-in gameplay features which are split up into *content packs*. Each content pack represents a certain category of gameplay features that can be enabled, disabled, and configured individually. This allows you to greatly customize your gameplay experience!

All content packs are optional and configurable via `Settings > All Settings > Content: Games > Asuna`.

### Nutrition

Nutrition grants benefits to players who stay well fed. A derivative of the "hunger" concept, Asuna revamps this familiar gameplay mechanic to be strictly beneficial to players in a way that aids in exploration and survival. Players will enjoy the following effects when they have eaten:

- Increased movement speed (up to +25% when full)
- The ability to sprint (+100% movement speed while holding the `aux1` key)
- Health regeneration (chance to recover health every five seconds)
- Resistance to poisonous foods (chance to lose nutrition instead of health)

These effects are most pronounced when a player is fully satiated and will diminish gradually as a player becomes hungry. Hunger will only diminish these effects and cannot hurt players unless starvation is explicitly enabled via game settings (disabled by default).

This functionality is implemented using a modified version of the popular [Stamina](https://content.minetest.net/packages/sofar/stamina/) mod.

### Wayfarer

From hidden treasures to teleportation gates, Wayfarer adds a number of features to Asuna that make exploration more interesting and worthwhile.

#### Awards

Awards are a set of accomplishments to strive for as you traverse the world. From simple tasks to feats of exemplary dedication, awards give you more to do in your world. Awards can also help guide you to features of Asuna that might not otherwise be obvious or intuitive.

Awards are implemented using a modified version of the popular [Awards](https://content.luanti.org/packages/rubenwardy/awards/) mod by Rubenwardy.

#### Loot Chests

You can find caches of useful items hidden throughout the caves and landscapes of Asuna. Loot chests, their contents, and their distribution are dependent on the environment in which they are found.

- **Baskets**: Found next to hills, trees, bushes, and in shallow caves, baskets contain items such as food, grasses, wood, seeds, flowers, and leaves.
- **Urns**: These stone vessels are found at a limited depth in caves and can contain tools, rope, stones, gems, crystals, ores, and some limited food items.
- **Ancient Chests**: These old stone chests are found rarely in caves and contain high quality tools, rare gems, mese crystals, and many exotic items that are otherwise rare in the world.
- **Ocean Chests**: These chests are found in deep ocean amidst dense kelp and near shipwrecks, and they contain a variety of useful items in addition to aquatic decorations.

These chests are implemented by a modified version of [LootChests modpack](https://content.minetest.net/packages/mt-mods/lootchest_modpack/).

#### Worldgates

Discover the Worldgates, an ancient teleportation network that can carry you to distant lands in an instant. Despite their long abandonment, the Worldgates are still highly functional. They can be found throughout the world, some more intact than others, and each adorned in stone by the elder hands that wrought them.

True to its name, this native teleportation network is implemented via the [Worldgate](https://content.luanti.org/packages/EmptyStar/worldgate/) mod.

### Menagerie

Nothing makes a world feel more alive than the creatures that inhabit it. Menagerie adds a variety of animals and creatures to Asuna.

#### Animals

Asuna is home to a number of wild animals which can be found roaming about their natural habitats. These animals are highly interactive and can be fed, bred, tamed, and hunted. These animals are implemented via the [Animalia](https://content.minetest.net/packages/ElCeejo/animalia/) mod which describes the animals in greater detail.

#### Slimes

Many species of living slimes are native to Asuna. Some of these slimes are docile foragers while others are more territorial. These slimes can be found in many places under the sun, deep underground, and even in oceans and waterways. See the [Living Slimes](https://content.minetest.net/packages/EmptyStar/livingslimes/) mod for information about the various slimes and their behaviors.

### Research

The Research content pack adds an *earned creative* mode to Asuna. Research allows you to unlock infinite duplication of the items in your world, but you must discover and/or create the items necessary for research. This is a more interesting alternative to Asuna's true creative mode and it's most useful when applied to survival worlds.

This feature is implemented via the [Researcher](https://content.luanti.org/packages/EmptyStar/researcher/) mod which thoroughly describes the research process.

Mods
----

For even more gameplay options, check out [ContentDB](https://content.minetest.net/) to find mods that can fulfill all of your wildest dreams. Asuna aims to maintain compatibility with mods that are compatible with Minetest Game.