# Living Slimes

Bring the classic fodder of fantasy adventure to your world with Living Slimes! From simple grass slimes to fire-belching lava slimes and everything in between, these living slimes can be found high and low throughout the world. Some are content to roam and forage while others are hostile hunters.

This mod is substantially based on [The Mana World slimes mod](https://github.com/mt-historical/tmw_slimes) by Piezo_ which was inspired by [The Mana World](https://themanaworld.org/).

## Slimes

The following slimes can be found in various environments throughout the world:

- **Grass Slime** - Found in grasslands and forests; loves to eat plants and leaves
- **Savanna Slime** - Found in savannas and dry plains; eats dry grass
- **Poisonous Slime** - Found in swamps and jungles; oozes poison and is harmful to the touch
- **Algae Slime** - Found in swamps and wetlands; docile attitude and loves to eat mushrooms
- **Ice Slime** - Found in icy and snowy biomes; subsists on ice and snow
- **Ocean Slime** - Found in bodies of water; small, gentle, and quick
- **Lava Slime** - Found in lava pools; very aggressive and spreads fire when provoked, also burns when touched
- **Mineral Slime** - Found underground; a sturdy slime that eats stones and rare minerals
- **Dark Slime** - Found in shadows underground; sneaky and malevolent

## Behaviors

### Eating

Slimes are eager to eat any items that are left on the ground near them. Many slimes favor weapons and tools, so beware that if you drop valuable items near them, they are likely to be eaten.

When no dropped items are available to eat, slimes will often dig up resources from their surrounding environment for sustenance. Most slimes have a preferred diet, and they will seek out foods that are most favorable to them.

### Digesting

Slimes will begin to digest the contents of their stomach after eating, a process which takes a few minutes per item eaten. When an item is digested, it is permanently destroyed without a trace. So if you suspect that a slime has eaten your items, be sure to get them back quickly!

Any items that a slime has not digested will be dropped when the slime is killed.

### Attacking

Most slimes are territorial and will pursue nearby players. Slime speeds, strength, and aggression vary by type, and they can only attack when they're close enough to a player to strike at close range although certain slimes have extra tricks up their sleeve (e.g., poisonous slimes and lava slimes).

### Stealing

When a slime successfully attacks a player, it's possible that the slime will rob the player of an item on their hotbar. When this happens, it's as though the slime has eaten the item meaning that it will be digested if left unrecovered.

Note that the stolen item can be the item in the player's hand, so be mindful of what you're holding!

## Drops and Resources

All slimes will drop at least one slime goo of its type when killed. This goo is edible with varying nutritional benefits or detriments.

Placing slime goo of the same kind in each square of a 3x3 crafting grid will create a slime block of that type. Slime blocks are slippery and bouncy, and they will prevent all fall damage from any height when landing on it from above.

## Settings

Many of the slime behaviors documented above can be enabled/disabled or adjusted via mod settings. Check the mod settings under `All Settings > Content: Mods > Living Slimes` for available settings. Also see [settingtypes.txt](https://github.com/EmptyStar/livingslimes/tree/main/settingtypes.txt) for a textual description of mod settings.

## Errors, Issues, and Bugs

Please [open an issue at GitHub](https://github.com/EmptyStar/livingslimes/issues/new) to report any problems encountered with this mod.