minetest.register_node("electrica:liquid_silicon_source", {
	description = "Liquid Silicon Source",
	drawtype = "liquid",
	tiles = {
		{
			name = "electrica_liquid_silicon_source_animated.png",
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	special_tiles = {
		-- New-style water source material (mostly unused)
		{
			name = "electrica_liquid_silicon_source_animated.png",
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
			backface_culling = false,
		},
	},
	alpha = 160,
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 0,
	liquidtype = "source",
	liquid_alternative_flowing = "electrica:liquid_silicon_flowing",
	liquid_alternative_source = "electrica:liquid_silicon_source",
	liquid_viscosity = 1,
	post_effect_color = {a = 103, r = 30, g = 30, b = 30},
	groups = {water = 3, liquid = 3, puts_out_fire = 1, cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("electrica:liquid_silicon_flowing", {
	description = "Flowing Silicon",
	drawtype = "flowingliquid",
	tiles = {"electrica_liquid_silicon.png"},
	special_tiles = {
		{
			name = "electrica_liquid_silicon_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.8,
			},
		},
		{
			name = "electrica_liguid_silicon_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.8,
			},
		},
	},
	alpha = 160,
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 0,
	liquidtype = "flowing",
	liquid_alternative_flowing = "electrica:liquid_silicon_flowing",
	liquid_alternative_source = "electrica:liquid_silicon_source",
	liquid_viscosity = 1,
	post_effect_color = {a = 103, r = 30, g = 30, b = 30},
	groups = {water = 3, liquid = 3, puts_out_fire = 1,
		not_in_creative_inventory = 0, cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})
