-- check for MineClone2
local mcl = minetest.get_modpath("mcl_core")

if mcl then
    torch='mcl_core:torch'
    cobble='mcl_core:cobble'
    basic_flame="mcl_fire:basic_flame"
else
    torch='default:torch'
    cobble='default:cobble'
    basic_flame="fire:basic_flame"
end

--Adds Brazier node
minetest.register_node("brazier:brazier", {
	description = "Brazier",
	drawtype = "nodebox",
	paramtype = "light",
	tiles = {"brazier_brazier_top.png", "brazier_brazier_side.png", "brazier_brazier_side.png",  "brazier_brazier_side.png", "brazier_brazier_side.png", "brazier_brazier_side.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{0.2,-0.2,0.2,-0.2,0.2,-0.2}, --nodebox1
			{-0.3,0.2,-0.3,0.3,0.3,0.3}, --nodebox2
			{-0.4,0.3,-0.4,0.4,0.4,0.4}, --nodebox3
			{-0.5,0.4,-0.5,0.5,0.5,0.5}, --nodebox4
			{-0.5,-0.5,-0.5,0.5,-0.4,0.5}, --nodebox5
			{-0.4,-0.4,-0.4,0.4,-0.3,0.4}, --nodebox6
			{-0.3,-0.3,-0.3,0.3,-0.2,0.3}, --nodebox7
		},
	},
	groups = {cracky = 3, stone = 1},
	--When punched set fire above
	on_punch = function(pos, node, puncher, pointed_thing)
		local ab_pos = { x = pos.x, y = pos.y + 1, z = pos.z}
		local n = minetest.env:get_node(ab_pos).name
		if (n == "air") then
			--Then set brazier flame
			minetest.set_node(ab_pos, {name = "brazier:brazier_flame"})
			end
	end,
	--When destroyed remove brazier fire
	after_destruct = function(pos, oldnode)
		--If above node is brazier fire
		local ab_pos = { x = pos.x, y = pos.y + 1, z = pos.z}
		local n = minetest.env:get_node(ab_pos).name
		if (n == "brazier:brazier_flame") then
			--Then remove brazier flame
			minetest.set_node(ab_pos, {name = "air"})
			end
	end,
})

--Register crafting recipie for brazier node
minetest.register_craft({
output = "brazier:brazier",
recipe = {
{'', torch, ''},
{cobble, cobble, cobble},
{cobble, cobble, cobble},
}
})

--Adds fake fire node
--It's a copy of the basic fire node, but it doesn't disappear
minetest.register_node("brazier:brazier_flame", {
	description = "Brazier Fire",
	drawtype = "plantlike",
	tiles = {{
		name="fire_basic_flame_animated.png",
		animation={type="vertical_frames", aspect_w=16, aspect_h=16, length=1},
	}},
	inventory_image = "fire_basic_flame.png",
	light_source = 14,
	groups = {igniter=2,dig_immediate=3,hot=3,not_in_creative_inventory=1},
	drop = '',
	walkable = false,
	buildable_to = true,
	damage_per_second = 4,
})

--Adds ABM to make brazier fire above brazier when there is basic fire nearby
minetest.register_abm({
	nodenames = {"brazier:brazier"},
	neighbors = {basic_flame},
	interval = 1.0,
	chance = 1,
	action = function(pos, node, active_object_count, active_object_count_wider)
		--Check if above node is air or fire
		local ab_pos = { x = pos.x, y = pos.y + 1, z = pos.z}
		local n = minetest.env:get_node(ab_pos).name
		if (n == "air" or n == basic_flame) then
			--Then set brazier flame
			minetest.set_node(ab_pos, {name = "brazier:brazier_flame"})
			end
	end,
})
