local S = minetest.get_translator(minetest.get_current_modname())

minetest.register_node("df_primordial_items:mushroom_trunk", {
	description = S("Primordial Mushroom Trunk"),
	_doc_items_longdesc = df_primordial_items.doc.giant_mushroom_desc,
	_doc_items_usagehelp = df_primordial_items.doc.giant_mushroom_usage,
	tiles = {"dfcaverns_mush_shaft_top.png", "dfcaverns_mush_shaft_top.png", "dfcaverns_mush_shaft_side.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2, handy=1,axey=1, building_block=1, material_wood=1, fire_encouragement=5, fire_flammability=5},
	sounds = df_trees.node_sound_tree_soft_fungus_defaults(),
	on_place = minetest.rotate_node,
	_mcl_blast_resistance = 3,
	_mcl_hardness = 3,
})

minetest.register_node("df_primordial_items:mushroom_cap", {
	description = S("Primordial Mushroom Cap"),
	_doc_items_longdesc = df_primordial_items.doc.giant_mushroom_desc,
	_doc_items_usagehelp = df_primordial_items.doc.giant_mushroom_usage,
	tiles = {"dfcaverns_mush_cap.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2, handy=1,axey=1, building_block=1, material_wood=1, fire_encouragement=5, fire_flammability=5},
	sounds = df_trees.node_sound_tree_soft_fungus_defaults(),
	on_place = minetest.rotate_node,
	_mcl_blast_resistance = 2,
	_mcl_hardness = 2,
})

minetest.register_node("df_primordial_items:mushroom_gills", {
	description = S("Primordial Mushroom Gills"),
	_doc_items_longdesc = df_primordial_items.doc.gills_desc,
	_doc_items_usagehelp = df_primordial_items.doc.gills_usage,
	tiles = {"dfcaverns_mush_gills.png"},
	inventory_image = "dfcaverns_mush_gills.png",
	wield_image = "dfcaverns_mush_gills.png",
	groups = {snappy = 3, flora = 1, flammable = 1, leaves = 1, leafdecay = 8,handy=1, hoey=1, shearsy=1, swordy=1, deco_block=1, dig_by_piston=1, fire_encouragement=15, fire_flammability=30, compostability=30},
	paramtype = "light",
	drawtype = "plantlike",
	waving = 2,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	sounds = df_dependencies.sound_leaves(),
	use_texture_alpha = "clip",
	sunlight_propagates = true,
	drop = {
		max_items = 1,
		items = {
			{
				-- player will get sapling with 1/20 chance
				items = {"df_primordial_items:mush_sapling"},
				rarity = 20,
			},
			{
				items = {"df_primordial_items:mushroom_gills"},
			}
		}
	},
	after_place_node = df_dependencies.after_place_leaves,
	place_param2 = 1, -- Prevent leafdecay for placed nodes
	_mcl_blast_resistance = 0.2,
	_mcl_hardness = 0.2,
})

minetest.register_node("df_primordial_items:mushroom_gills_glowing", {
	description = S("Glowing Primordial Mushroom Gills"),
	_doc_items_longdesc = df_primordial_items.doc.gills_desc,
	_doc_items_usagehelp = df_primordial_items.doc.gills_usage,
	tiles = {"dfcaverns_mush_gills_glow.png"},
	inventory_image = "dfcaverns_mush_gills_glow.png",
	wield_image = "dfcaverns_mush_gills_glow.png",
	groups = {snappy = 3, flora = 1, flammable = 1, leaves = 1, leafdecay = 8,handy=1, hoey=1, shearsy=1, swordy=1, deco_block=1, dig_by_piston=1, fire_encouragement=15, fire_flammability=30, compostability=30},
	paramtype = "light",
	drawtype = "plantlike",
	waving = 2,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	light_source = 6,
	sounds = df_dependencies.sound_leaves(),
	use_texture_alpha = "clip",
	sunlight_propagates = true,
	drop = {
		max_items = 1,
		items = {
			{
				-- player will get sapling with 1/20 chance
				items = {"df_primordial_items:mush_sapling"},
				rarity = 20,
			},
			{
				items = {"df_primordial_items:mushroom_gills_glowing"},
			}
		}
	},
	after_place_node = df_dependencies.after_place_leaves,
	place_param2 = 1, -- Prevent leafdecay for placed nodes
	_mcl_blast_resistance = 0.2,
	_mcl_hardness = 0.2,
})

df_dependencies.register_leafdecay({
	trunks = {"df_primordial_items:mushroom_trunk", "df_primordial_items:mushroom_cap"},
	leaves = {"df_primordial_items:mushroom_gills", "df_primordial_items:mushroom_gills_glowing"},
	radius = 5,
})

minetest.register_node("df_primordial_items:primordial_mush_trunk_wood", {
	description = S("Primordial Mushroom Trunk Wood"),
	_doc_items_longdesc = df_primordial_items.doc.giant_mushroom_desc,
	_doc_items_usagehelp = df_primordial_items.doc.giant_mushroom_usage,
	paramtype2 = "facedir",
	tiles = {"dfcaverns_mush_shaft_side.png^(dfcaverns_mush_gills.png^[multiply:#888888)"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, handy=1,axey=1, building_block=1, material_wood=1, fire_encouragement=5, fire_flammability=20},
	sounds = df_dependencies.sound_wood(),
	_mcl_blast_resistance = 4,
	_mcl_hardness = 3,
})

minetest.register_craft({
	output = "df_primordial_items:primordial_mush_trunk_wood 4",
	recipe = {
		{"df_primordial_items:mushroom_trunk"},
	}
})

df_dependencies.register_all_stairs_and_fences("primordial_mush_trunk_wood", {burntime = 7})

minetest.register_node("df_primordial_items:primordial_mush_cap_wood", {
	description = S("Primordial Cap Wood"),
	_doc_items_longdesc = df_primordial_items.doc.giant_mushroom_desc,
	_doc_items_usagehelp = df_primordial_items.doc.giant_mushroom_usage,
	paramtype2 = "facedir",
	tiles = {"dfcaverns_mush_cap.png^dfcaverns_mush_gills.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, handy=1,axey=1, building_block=1, material_wood=1, fire_encouragement=5, fire_flammability=20},
	sounds = df_dependencies.sound_wood(),
	_mcl_blast_resistance = 3,
	_mcl_hardness = 2,
})

minetest.register_craft({
	output = "df_primordial_items:primordial_mush_cap_wood 4",
	recipe = {
		{"df_primordial_items:mushroom_cap"},
	}
})

df_dependencies.register_all_stairs_and_fences("primordial_mush_cap_wood", {burntime=12})

minetest.register_craft({
	type = "fuel",
	recipe = "df_primordial_items:primordial_mush_cap_wood",
	burntime = 12,
})
minetest.register_craft({
	type = "fuel",
	recipe = "df_primordial_items:primordial_mush_trunk_wood",
	burntime = 7,
})
minetest.register_craft({
	type = "fuel",
	recipe = "df_primordial_items:mushroom_cap",
	burntime = 40,
})
minetest.register_craft({
	type = "fuel",
	recipe = "df_primordial_items:mushroom_trunk",
	burntime = 30,
})
minetest.register_craft({
	type = "fuel",
	recipe = "df_primordial_items:mushroom_gills",
	burntime = 2,
})
minetest.register_craft({
	type = "fuel",
	recipe = "df_primordial_items:mushroom_gills_glowing",
	burntime = 4,
})
minetest.register_craft({
	type = "fuel",
	recipe = "df_primordial_items:mush_sapling",
	burntime = 2,
})

------
-- Schematics:
-- Originally created by ClockGen, released under CC-BY 4.0

local replace_on_buildable_to = function(old_node_id, data, area, vi)
	return mapgen_helper.buildable_to(old_node_id)
end

local n1 = {name="air", prob=0}
local n2 = {name="df_primordial_items:mushroom_gills"}
local n3 = {name="df_primordial_items:mushroom_cap", place_on_condition = replace_on_buildable_to}
local n4 = {name="df_primordial_items:mushroom_trunk", place_on_condition = replace_on_buildable_to}
local n5 = {name="df_primordial_items:mushroom_gills_glowing"}

local bc_mushroom_3 = {
	size = {x=3, y=3, z=3},
	center_pos = {x=1, y=0, z=1},
	data = {
		n1, n1, n1, n2, n2, n1, n3, n3, n3, n1, n4, n1, n2, n4, n5, n3, n3,
		n3, n1, n1, n1, n1, n5, n1, n3, n3, n3,
	},
}

local bc_mushroom_5 = {
	size = {x=5, y=5, z=5},
	center_pos = {x=2, y=0, z=2},
	data = {
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3,
		n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n2, n1, n1, n1, n3, n2, n5, n2, n3, n1, n3, n3, n3, n1, n1,
		n1, n4, n1, n1, n1, n1, n4, n1, n1, n1, n2, n4, n5, n1, n3, n2, n4,
		n5, n3, n1, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n5, n2, n1, n1, n3, n5, n2, n2, n3, n1, n3, n3, n3, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3,
		n1, n1, n1, n1, n1, n1,
	},
}

local bc_mushroom_9 = {
	size = {x=9, y=9, z=9},
	center_pos = {x=4, y=0, z=4},
	data = {
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3,
		n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n2, n3, n3, n3, n1,
		n1, n1, n1, n1, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1,
		n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n5,
		n2, n1, n1, n1, n1, n3, n3, n2, n5, n2, n3, n3, n1, n1, n1, n1, n3,
		n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1,
		n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1,
		n3, n3, n2, n2, n5, n2, n2, n3, n3, n1, n1, n3, n3, n3, n3, n3, n1,
		n1, n1, n1, n1, n1, n4, n1, n1, n1, n1, n1, n1, n1, n1, n4, n1, n1,
		n1, n1, n1, n1, n1, n1, n4, n1, n1, n1, n1, n1, n1, n1, n1, n4, n1,
		n1, n5, n1, n1, n5, n1, n1, n4, n2, n1, n5, n1, n1, n5, n1, n5, n4,
		n2, n1, n5, n1, n1, n5, n1, n5, n4, n2, n2, n5, n1, n3, n5, n2, n5,
		n4, n2, n5, n5, n3, n1, n3, n3, n3, n3, n3, n3, n3, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1,
		n1, n1, n2, n1, n1, n2, n1, n1, n1, n1, n1, n2, n1, n2, n2, n1, n1,
		n1, n1, n1, n2, n5, n2, n2, n1, n1, n3, n3, n5, n2, n5, n2, n2, n3,
		n3, n1, n1, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n5,
		n1, n1, n1, n1, n1, n1, n3, n3, n5, n2, n2, n3, n3, n1, n1, n1, n1,
		n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1,
		n1, n1, n3, n3, n3, n5, n3, n3, n3, n1, n1, n1, n1, n1, n3, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
		n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1,
	},
}

local bc_mushroom_21 = {
	size = {y = 21, x = 19, z = 19},
	center_pos = {x=9, y=0, z=9},
	data = {
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n2, n3, 
		n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, 
		n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, 
		n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n5, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n5, n5, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n3, n3, n5, n5, n5, n5, n2, n3, n3, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n3, n3, n3, n3, n5, n3, n3, n3, n3, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n2, n1, n1, n2, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n2, n1, n1, n2, n1, n5, n2, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n2, n1, n5, n2, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n2, n1, n5, n2, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n2, n1, n1, n2, n1, n5, 
		n2, n3, n3, n3, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n2, n5, n2, 
		n2, n5, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, 
		n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, 
		n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, 
		n5, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n5, n1, n2, n2, 
		n1, n1, n5, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n5, n1, 
		n2, n2, n1, n1, n5, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, 
		n5, n1, n2, n2, n1, n2, n5, n1, n5, n1, n1, n1, n1, n1, n1, n1, n3, 
		n5, n2, n5, n1, n2, n2, n1, n2, n5, n2, n5, n3, n1, n1, n1, n1, n1, 
		n1, n3, n3, n3, n5, n2, n2, n2, n5, n2, n5, n3, n3, n3, n1, n1, n1, 
		n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n3, n3, n3, n3, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n2, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n2, n1, n1, n1, n1, n2, n2, n2, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n5, n1, n2, n1, n1, n1, n2, n2, n2, n2, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n5, n1, n2, n1, n1, n1, n2, n2, n2, n2, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n5, n1, n2, n1, n1, n1, n2, n2, n2, n2, 
		n1, n1, n1, n1, n1, n1, n3, n3, n2, n5, n1, n2, n1, n1, n1, n2, n2, 
		n2, n2, n3, n3, n1, n1, n1, n1, n3, n3, n3, n5, n2, n2, n5, n5, n2, 
		n2, n2, n2, n3, n3, n3, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n4, 
		n4, n4, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, 
		n3, n3, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n2, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, 
		n2, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n2, n1, 
		n2, n1, n2, n1, n1, n1, n1, n1, n1, n2, n1, n1, n2, n1, n1, n1, n2, 
		n2, n1, n2, n5, n2, n1, n1, n1, n1, n1, n1, n2, n1, n1, n2, n1, n1, 
		n1, n2, n2, n2, n2, n5, n2, n1, n1, n1, n1, n1, n1, n2, n1, n1, n2, 
		n1, n1, n1, n2, n2, n2, n2, n5, n2, n1, n1, n1, n1, n3, n3, n2, n1, 
		n1, n2, n1, n1, n5, n2, n2, n2, n2, n5, n2, n3, n3, n1, n1, n3, n3, 
		n3, n2, n2, n2, n2, n5, n4, n2, n2, n2, n2, n5, n3, n3, n3, n1, n1, 
		n1, n1, n3, n3, n3, n3, n4, n4, n4, n4, n4, n3, n3, n3, n3, n1, n1, 
		n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n3, n3, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, 
		n1, n1, n1, n1, n5, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n2, n1, n1, n1, n1, n5, n5, n1, n1, n1, n1, n2, n5, n1, n1, n1, 
		n1, n1, n1, n2, n1, n1, n1, n1, n5, n5, n1, n1, n1, n1, n2, n5, n1, 
		n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n5, n5, n1, n2, n1, n1, n2, 
		n5, n1, n1, n1, n3, n2, n1, n2, n1, n1, n1, n2, n4, n5, n1, n2, n1, 
		n1, n2, n5, n3, n1, n1, n3, n3, n2, n2, n5, n5, n2, n4, n4, n4, n2, 
		n2, n2, n2, n2, n3, n3, n1, n1, n1, n3, n3, n3, n3, n4, n4, n4, n4, 
		n4, n4, n4, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, 
		n3, n3, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, 
		n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n2, n2, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n4, n4, n4, n2, n2, n2, 
		n1, n1, n2, n1, n1, n1, n1, n5, n5, n1, n1, n1, n1, n4, n4, n4, n2, 
		n2, n2, n1, n1, n2, n1, n1, n1, n1, n5, n5, n1, n1, n5, n2, n4, n4, 
		n4, n2, n2, n2, n1, n1, n2, n1, n1, n1, n1, n5, n5, n1, n1, n5, n2, 
		n4, n4, n4, n2, n2, n2, n1, n5, n2, n1, n1, n3, n3, n5, n5, n1, n1, 
		n5, n2, n4, n4, n4, n2, n2, n2, n1, n5, n2, n3, n3, n3, n3, n3, n5, 
		n5, n2, n5, n4, n4, n4, n4, n4, n2, n2, n2, n5, n3, n3, n3, n1, n1, 
		n3, n3, n3, n4, n4, n4, n4, n4, n4, n4, n4, n4, n3, n3, n3, n1, n1, 
		n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n3, n3, n3, n3, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, 
		n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n4, n4, 
		n4, n1, n1, n1, n1, n1, n1, n2, n1, n1, n2, n1, n1, n1, n1, n1, n5, 
		n4, n4, n4, n1, n1, n1, n1, n1, n1, n2, n1, n1, n2, n1, n1, n1, n5, 
		n1, n5, n4, n4, n4, n2, n1, n1, n1, n1, n1, n2, n1, n1, n2, n1, n1, 
		n1, n5, n1, n5, n4, n4, n4, n2, n1, n1, n1, n2, n1, n2, n1, n1, n2, 
		n1, n1, n1, n5, n1, n5, n4, n4, n4, n2, n1, n1, n1, n2, n1, n2, n1, 
		n1, n2, n1, n1, n1, n5, n1, n5, n4, n4, n4, n2, n1, n1, n1, n2, n1, 
		n2, n1, n3, n2, n1, n1, n1, n5, n2, n4, n4, n4, n4, n4, n5, n1, n1, 
		n2, n1, n2, n3, n3, n3, n2, n2, n5, n5, n4, n4, n4, n4, n4, n4, n4, 
		n2, n2, n2, n2, n3, n3, n1, n1, n3, n3, n3, n4, n4, n4, n4, n4, n4, 
		n4, n4, n4, n3, n3, n3, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, 
		n3, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, 
		n3, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, 
		n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n4, n4, n4, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n4, n4, n4, n5, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n4, n4, n4, n5, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n4, n4, n4, n5, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n2, n4, n4, n4, n5, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n2, n4, n4, n4, 
		n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n2, n4, 
		n4, n4, n5, n1, n1, n1, n1, n1, n1, n1, n3, n3, n2, n2, n1, n1, n1, 
		n2, n4, n4, n4, n5, n1, n1, n1, n1, n2, n3, n3, n3, n3, n3, n2, n2, 
		n5, n5, n4, n4, n4, n4, n4, n2, n5, n5, n2, n3, n3, n3, n1, n1, n3, 
		n3, n3, n4, n4, n4, n4, n4, n4, n4, n4, n4, n3, n3, n3, n1, n1, n1, 
		n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n3, n3, n3, n3, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n2, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n2, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n5, n2, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n5, n2, n1, n1, n1, n1, n1, n1, n5, n1, 
		n1, n1, n3, n5, n1, n1, n1, n1, n1, n5, n4, n2, n1, n1, n1, n1, n1, 
		n5, n3, n1, n1, n3, n3, n5, n5, n2, n5, n2, n4, n4, n4, n2, n2, n2, 
		n2, n5, n3, n3, n1, n1, n1, n3, n3, n3, n3, n4, n4, n4, n4, n4, n4, 
		n4, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, 
		n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, 
		n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n5, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, 
		n5, n5, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n5, n1, n1, n1, n1, 
		n1, n2, n5, n5, n1, n1, n1, n5, n3, n3, n1, n1, n3, n3, n3, n5, n2, 
		n5, n2, n2, n4, n5, n5, n2, n2, n5, n3, n3, n3, n1, n1, n1, n1, n3, 
		n3, n3, n3, n4, n4, n4, n4, n4, n3, n3, n3, n3, n1, n1, n1, n1, n1, 
		n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, 
		n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, 
		n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n2, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n2, n5, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n2, n5, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n2, n5, n1, n2, n2, n1, n1, n1, n1, n1, n1, 
		n1, n1, n3, n3, n2, n1, n1, n1, n2, n5, n2, n2, n2, n1, n2, n3, n3, 
		n1, n1, n1, n1, n3, n3, n3, n5, n2, n5, n2, n5, n2, n2, n2, n5, n3, 
		n3, n3, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n4, n4, n4, n3, n3, 
		n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, 
		n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, 
		n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n5, n1, n1, n1, n2, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n5, n1, n5, n1, n2, n1, n2, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n5, n1, n5, n1, n2, n1, n2, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n5, n1, n5, n1, n2, n1, n2, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n5, n1, n2, n1, n2, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n5, n1, n2, n2, 
		n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n2, n5, n1, n5, n1, 
		n2, n2, n2, n1, n5, n5, n3, n1, n1, n1, n1, n1, n1, n3, n3, n3, n2, 
		n5, n2, n2, n2, n2, n5, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n3, 
		n3, n3, n3, n3, n3, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, 
		n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n2, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n2, n5, n2, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n3, n3, n3, n2, n5, n2, n2, n1, n1, n2, n3, n3, n3, n1, n1, 
		n1, n1, n1, n1, n3, n3, n3, n3, n5, n2, n2, n5, n5, n3, n3, n3, n3, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n5, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, 
		n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, 
		n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n5, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n5, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n5, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n5, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n5, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n5, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n5, n1, n1, n1, n5, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n5, n5, n1, 
		n2, n5, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, 
		n3, n2, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n3, n3, n3, n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n2, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n2, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n3, n3, n3, n2, n3, n3, n3, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n3, n3, n3, n3, n3, n3, n3, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, n3, n3, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n3, 
		n3, n3, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
		n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, n1, 
	}
}

df_primordial_items.get_primordial_mushroom = function()
	local rand = math.random()
	if rand < 0.3 then
		return bc_mushroom_3
	elseif rand < 0.7 then
		return bc_mushroom_5
	elseif rand < 0.975 then
		return bc_mushroom_9
	end
	return bc_mushroom_21
end

minetest.register_node("df_primordial_items:mush_sapling", {
	description = S("Primordial Mushroom Spawn"),
	_doc_items_longdesc = df_primordial_items.doc.giant_mushroom_desc,
	_doc_items_usagehelp = df_primordial_items.doc.giant_mushroom_usage,
	tiles = {"dfcaverns_mush_sapling.png"},
	inventory_image = "dfcaverns_mush_sapling.png",
	wield_image = "dfcaverns_mush_sapling.png",
	groups = {snappy = 3, flora = 1, attached_node = 1, flammable = 1, sapling = 1, light_sensitive_fungus = 11, dig_by_piston=1,destroy_by_lava_flow=1,deco_block=1, compostability=30,dig_immediate=3},
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, 7 / 16, 4 / 16}
	},
	paramtype = "light",
	drawtype = "plantlike",
	buildable_to = true,
	walkable = false,
	is_ground_content = false,
	sounds = df_dependencies.sound_leaves(),
	use_texture_alpha = "clip",
	sunlight_propagates = true,
	_mcl_blast_resistance = 0.2,
	_mcl_hardness = 0.2,
	on_construct = function(pos)
		if df_primordial_items.primordial_mushroom_growth_permitted(pos) then
			minetest.get_node_timer(pos):start(math.random(
				df_trees.config.tree_min_growth_delay,
				df_trees.config.tree_max_growth_delay))
		end
	end,
	on_destruct = function(pos)
		minetest.get_node_timer(pos):stop()
	end,
	on_timer = function(pos, elapsed)
		if df_farming and df_farming.kill_if_sunlit(pos) then
			return
		end
		df_primordial_items.spawn_primordial_mushroom(pos)
	end,
})

df_primordial_items.spawn_primordial_mushroom = function(pos)
	local mushroom = df_primordial_items.get_primordial_mushroom()
	local rotation = (math.random(1,4)-1)*90
	minetest.set_node(pos, {name="air"}) -- clear sapling so mushroom can replace it
	mapgen_helper.place_schematic(pos, mushroom, rotation)
end