Inspired by the world of Dwarf Fortress, this mod adds a series of vast cavern layers to the depths of Minetest with a variety of biomes that are populated with the flora of Dwarf Fortress.

## Cavern Layers

The underground is divided into a number of cavern "layers" with a variety of biomes and other features distributed throughout. As one goes deeper one will find increasingly bizzare flora and exotic environments that provide new challenges and opportunities for players.

The uppermost layer is home to relatively conventional tree-like fungal growths of Fungiwood and Tower-Cap mushrooms. These provide a source of underground wood. Also found in this region are plump helmets (an edible farmable mushroom), and cave wheat (a pale grass-like growth whose seeds can be ground for flour).

The next layer down has more exotic growths. Here you can find Goblin Cap mushrooms, the squatter cousins of the Tower Caps. Spore Trees sprout in the warmer and wetter corners of the caverns, raising a climbable three-dimensional mesh or hyphyae above the ground that emits a gentle rain of spore powder. Tunnel Tubes grow in the hottest regions - tall, curved stalks with fruiting bodies at the tips that burst violently when ripe. Smaller growths found here include plump helmets, cave wheat, pig tails (a fibrous fungus that can be grown and harvested for thread) and sweet pods (whose fruiting bodies can be milled for sugar or processed into syrup).

In the third cavern layer yet stranger forms of life flourish in the hostile conditions. The coal-black caverns of the Black Cap forests, rich with carbonaceous deposits that have accumulated over millions of years and lit by smouldering Torchspines, are found here. The frigid Nethercaps, blue-tinted mushrooms leaching heat out of their environment in ways that shouldn't be thermodynamically possible, fill their caverns with ice and snow. In the hotter areas the vicious Bloodthorn grows, with wicked spines that suck moisture from anything they can pierce. In caves too dry to support biological life enormous glowing crystals grow instead. Smaller plants that can be found here include quarry bushes (farmable for their spicy leaves) and dimple cups (whose eponymous parts can be ground to produce a brilliant blue dye).

After the third layer are the shores of the Sunless Sea, the ultimate destination of all water that flows downward through the twisty caves of Minetest. Familiar growths crowd its fertile shores, with Tower Cap, Goblin Cap, Fungiwood and Spore Trees able to take root in this relatively hospitable zone. The caverns of the Sunless Sea are vast in extent but are mostly flooded with water, and below the surface grows treacherous Snareweed and underwater citadels of softly-glowing Cave Coral. Twisting rivers connect the various caverns of the Sunless Sea.

Below the Sunless Sea are seas of a more dangerous sort: lakes of oil and the magma ocean. These caverns are filled with dangerous substances, though there are riches to be had as well; mineral growths fed by the heat and pressure and bountiful fuel sources.

At the very foundation of the world lies an ancient impenetrable realm. There are signs that life once existed here but it is now long gone. Its dead hollows rest on a layer of Slade, a dense material impervious to conventional mining efforts.

Unconventional methods of penetrating the Slade do exist, however. And should it be breached, the exotic Primordial cavern layer can be found beneath.

## Other Features

The giant caverns generated by this mod differ slightly from the default giant caverns found in some mapgens, they use an additional source of noise to generate more ledges and horizontal floors. They also contain stalactites and stalagmites of various sizes - from single-node spikes decorating the default twisty tunnels to mountainous behemoths in the main caverns that can reach tens of meters in diameter and hundreds of meters in height.

The trees and plants mentioned above are all farmable, but in contrast to the usual farmable plants and trees they only grow in the *absence* of bright light. Attempting to plant them in sunlight will kill them. A set of recipes is added for cooking the edible ones into a variety of biscuits, stews, and roasts, and sweet pods can be refined into syrup.

Some of the other cave decorations provide dim bioluminescent lighting in some caverns. Cave moss and hanging glow-worms are most common. There is also non-glowing floor fungus found coating the stone in less hospitable biomes, capable of spreading to adjacent cobblestone structures like a slow-creeping infection.

[A more comprehensive guide can be found here.](guide.md)

[APIs and player commands can be found here.](API.md)

## Synergies with other mods

"[dynamic liquid](https://github.com/minetest-mods/dynamic_liquid)" is recommended to provide Dwarf Fortress-like fluid dynamics and to deal with water that might spill into caverns.

"[magma conduits](https://github.com/FaceDeer/magma_conduits/)" is recommended for a Dwarf Fortress like magmatic landscape. If not magma conduits, it is at least recommended that mapgen magma be disabled on whatever mapgen you're adding this mod to; mapgen magma is difficult for lua mapgens like this to tidy up and it will often spill into caverns setting large swaths of fungal forests on fire. Depending on the mapgen you're using this mod with you could do this by setting ``mgv5_lava_depth, mgv7_lava_depth``, ``mgcarpathian_lava_depth``, ``mgflat_lava_depth``, ``mgfractal_lava_depth``, or ``mgvalleys_lava_depth`` to -2800 (near the default depth of the magma sea).

The "[doc](https://forum.minetest.net/viewtopic.php?f=9&t=15912&p=240152)" mod is supported to provide in-game documentation for all of the new items and nodes this mod adds.

"[ropes](https://github.com/minetest-mods/ropes)" are very useful for navigating some of the large open spaces this mod provides. Some are large enough that a [glider](https://github.com/CBugDCoder/glider) may be well suited.

"[radiant damage](https://github.com/FaceDeer/radiant_damage)" greatly increases the danger of the Magma Sea if heat radiance is enabled, as well as several of the rare crystals in the deeper layers that emit Mese radiation if that damage type is enabled.

Adding "[named_waypoints](https://github.com/FaceDeer/named_waypoints)" and "[namegen](https://github.com/FaceDeer/namegen)" will provide some landmarks in the Underworld that a player can use to navigate by.