Inspired by the world of Dwarf Fortress, this mod adds a series of vast cavern layers to the depths of Minetest with a variety of biomes that are populated with the flora of Dwarf Fortress.

## Cavern Layers

The underworld is divided into a number of cavern "layers" with a variety of biomes and other features distributed throughout. As one goes deeper one will find increasingly bizzare flora and exotic environments that provide new challenges and opportunities for players.

The uppermost layer has "flooded" and "dry" caverns, as well as caverns containing the massive tree-like fungal growths of Fungiwood and Tower-Cap mushrooms. These provide a source of underground wood. Also found in this region are plump helmets (an edible farmable mushroom), pig tails (a fibrous fungus that can be grown and harvested for thread), and cave wheat (a pale grass-like growth whose seeds can be ground for flour).

Fungiwood and Tower Caps can still be found the next layer down, though in smaller ranges as they are crowded by several new types of giant fungi. Here you can find Goblin Cap mushrooms, the squatter cousins of the Tower Caps. Spore Trees sprout in the warmer and wetter corners of the caverns, raising a climbable three-dimensional mesh or hyphyae above the ground that emits a gentle rain of spore powder. Tunnel Tubes grow in the hottest regions - tall, curved stalks with fruiting bodies at the tips that burst violently when ripe. And in the dryest regions are the pitch-black caverns of the Black Cap forests, rich with carbonaceous deposits that have accumulated over millions of years. Smaller plants that can be found here include quarry bushes (farmable for their spicy leaves) and dimple cups (whose eponymous parts can be ground to produce a brilliant blue dye).

The third cavern layer no longer supports Fungiwood or Tower Caps, with strange new growths crowding them out. The frigid Nethercap caverns can be found here, the blue-tinted mushrooms leaching heat out of their environment in ways that shouldn't be thermodynamically possible. In the hotter areas the vicious Bloodthorn grows, with wicked spines that suck moisture from anything they can pierce. In caves too dry to support biological life enormous glowing crystals grow instead. Sweet pods can be found down here, a fungus whose fruiting bodies are rich in sugary substances.

The third layer stops on the shores of the Sunless Sea, the ultimate destination of all water that flows downward through the twisty caves of Minetest. The caverns of the Sunless Sea are vast in extent but are flooded with water, and below the surface grows treacherous Snareweed and the rare hanging forests of softly-glowing Cave Coral.

Below the Sunless Sea is a sea of a more dangerous sort: the Magma Ocean. These caverns are filled with dangerous molten rock, though there are riches to be had as well; mineral growths fed by the heat and pressure.

By default, caverns belonging to the first cavern layer can be found between -300 and -900, the second cavern layer between -900 and -1500, and the third cavern layer between -1500 and -2100. The surface level of the Sunless Sea is at -2300 and the magma sea's surface is at -3150.

## Other features

The giant caverns generated by this mod differ slightly from the default giant caverns found in some mapgens, they use an additional source of noise to generate more ledges and horizontal floors. They also contain stalactites and stalagmites of various sizes - from single-node spikes decorating the default twisty tunnels to mountainous behemoths in the main caverns that can reach tens of meters in diameter and hundreds of meters in height.

The trees and plants mentioned above are all farmable, but in contrast to the usual farmable plants and trees they only grow in the *absence* of bright light; attempting to plant them in sunlight will kill them. A set of recipes is added for cooking the edible ones into a variety of biscuits, stews, and roasts, and sweet pods can be refined into syrup.

Some of the other cave decorations provide dim bioluminescent lighting in some caverns. Cave moss and hanging glow-worms are most common. There is also non-glowing floor fungus found coating the stone in less hospitable biomes, capable of spreading to adjacent cobblestone structures like a slow-creeping infection.

## Dependencies and synergies with other mods

This mod depends on the utility mod "subterrane", which was derived from Caverealms code which in turn was derived from Paramat's subterrain.

"dynamic liquid" is also recommended to provide Dwarf Fortress-like fluid dynamics. "magma conduits" is recommended for a Dwarf Fortress like magmatic landscape.

The "doc" mod is supported to provide in-game documentation for all of the new items and nodes this mod adds.