if not minetest.get_modpath("doc") then
	return
end

local S = df_primordial_items.S

df_primordial_items.doc.big_mushroom_desc = S("Compared to the behemoths found elsewhere in the deep places of the world, the giant mushrooms of the primordial jungles are on the smaller side - often overwhelmed by the green plants that grow in the mysterious light below. Still, they can become substantial resources.")
df_primordial_items.doc.big_mushroom_usage = S("The soft flesh of these large mushrooms is much less woody than other giant mushrooms, making it ill-suited to structural use. This makes it rather more nutritious, however.")

df_primordial_items.doc.dirt_with_jungle_grass_desc = S("The soil of the primordial jungle is rife with strange life at every scale.")
df_primordial_items.doc.dirt_with_jungle_grass_usage = S("When left uncultivated primordial jungle soil will sprout all manner of strange wild plants.")
df_primordial_items.doc.dirt_with_mycelium_desc = S("Fungal fibers have infiltrated the ground in a spongy mass, making the soil half mineral and half living matter.")
df_primordial_items.doc.dirt_with_mycelium_usage = S("When left uncultivated mycelial soil will sprout all manner of strange wild fungi.")

df_primordial_items.doc.fern_desc = S("The dark-leaved ferns of the primordial jungle harken back to an earlier era of life in the world.")
--df_primordial_items.doc.fern_usage =
df_primordial_items.doc.grass_desc = S("These fibrous plants that grow in the deep appear similar to grass at a glance, but they are more closely related to horsetails - a form of vegetation from before the advent of modern plant forms. Ironically, pale cave wheat is more kin to surface grass than this is.")
--df_primordial_items.doc.grass_usage =

df_primordial_items.doc.ivy_desc = S("Tangled weaves of ivy hang from the ceiling where there are wide enough gaps between the bright sources of light.")
df_primordial_items.doc.ivy_usage = S("Ivy is climbable, if it hangs close enough to the ground it can serve as a path between floor and ceiling.")
df_primordial_items.doc.roots_desc = S("Somewhere above an enormous plant has wedged its roots down through the rock and emerged from the ceiling of another cavern.")
df_primordial_items.doc.roots_usage = S("These hanging roots are climbable.")

df_primordial_items.doc.fungal_grass_desc = S("Questing fibers of fungal mycelium sometimes erupt from the soil and reach upward, driven by chemical cues to seek out nourishment above. They look a lot like white grass, at a glance.")
--df_primordial_items.doc.fungal_grass_usage =

df_primordial_items.doc.tree_desc = S("The large woody plants of the primordial jungle are similar in appearance to the jungle trees of the surface, but are a result of convergent evolution from ancient cycad plants toward a common form.")
df_primordial_items.doc.tree_usage = S("Like wood of the surface world, primordial jungle trees can be chopped and carved as building material or as fuel.")
df_primordial_items.doc.tree_glowing_desc = S("The cracks in the bark of some primordial jungle trees become host to phosphorescent veins of symbiotic fungus.")
df_primordial_items.doc.tree_glowing_usage = S("The glowing bark fungus doesn't extend into the wood of the trunk, resulting in surprisingly mundane building material when hewn.")
--df_primordial_items.doc.leaves_desc =
--df_primordial_items.doc.leaves_usage =
df_primordial_items.doc.glowing_leaves_desc = S("Some fronds of primordial jungle trees also become host to the phosphorescent fungus that creeps through cracks in the bark.")
--df_primordial_items.doc.glowing_leaves_usage =

df_primordial_items.doc.giant_fern_desc = S("The still air of these ancient caverns have allowed ferns to grow to prodigious sizes, where storms and rain would normally tear their weaker fronds off on the surface of the world.")
df_primordial_items.doc.giant_fern_usage = S("When a fern grows to such sizes its stem becomes dense enough to be used as a form of wood.")

df_primordial_items.doc.giant_hyphae_desc = S("Fungus in its purest form, these gigantic rope-like hyphae creep over the surface of soil and burrow in to feed wherever nutrients are sensed.")
df_primordial_items.doc.giant_hyphae_usage = S("Much like a rope, hyphae have fibers inside that can be unraveled and used for a variety of crafts.")
df_primordial_items.doc.mycelial_fibers_desc = S("Fibers extracted from gigantic fungal hyphae.")
--df_primordial_items.doc.mycelial_fibers_usage =
df_primordial_items.doc.mycelial_thread_desc = df_primordial_items.doc.mycelial_fibers_desc
--df_primordial_items.doc.mycelial_thread_usage =

df_primordial_items.doc.giant_mushroom_desc = S("The grandest of the great mushroom species can be found in the deepest primordial caverns. Their broad caps have hanging gills.")
df_primordial_items.doc.giant_mushroom_usage = S("Much like the giant mushrooms of higher cavern layers, these can be carved into woody material for use as fuel or for building things. The grain of these primordial mushrooms is knurled.")
--df_primordial_items.doc.gills_desc =
--df_primordial_items.doc.gills_usage =

--df_primordial_items.doc.glow_orb_desc =
--df_primordial_items.doc.glow_orb_usage =
--df_primordial_items.doc.glow_plant_desc =
--df_primordial_items.doc.glow_plant_usage =
--df_primordial_items.doc.glow_pod_desc =
--df_primordial_items.doc.glow_pod_usage =

-- The giant hanging fungal structures from the ceiling
--df_primordial_items.doc.glownode_desc =
--df_primordial_items.doc.glownode_usage =
--df_primordial_items.doc.glownode_stalk_desc =
--df_primordial_items.doc.glownode_stalk_usage =

df_primordial_items.doc.packed_roots_desc = S("The steady light and unchanging growing conditions of the primordial caverns have led to great mountainous masses of plant material growing in particularly fertile spots, hardly identifiable as individual organisms.")
df_primordial_items.doc.packed_roots_usage = S("The gnarled interwoven root-like foundations of this plant material is not useful as building material, but can serve as a fuel source.")
df_primordial_items.doc.plant_matter_desc = df_primordial_items.doc.packed_roots_desc
df_primordial_items.doc.plant_matter_usage = df_primordial_items.doc.packed_roots_usage

--df_primordial_items.doc.small_mushroom_desc =
--df_primordial_items.doc.small_mushroom_usage =
--
--df_primordial_items.doc.thorn_desc =
--df_primordial_items.doc.thorn_usage =

df_primordial_items.doc.primordial_fruit_desc = S("This strange fruit from the depths has absorbed healthful energies.")
df_primordial_items.doc.primordial_fruit_usage = S("Eating this fruit will improve your vitality.")

df_primordial_items.doc.glowtato_desc = S("A strangely glowing starchy nodule from a plant that grew deeper than any plant has a right to.")
df_primordial_items.doc.glowtato_usage = S("Much energy is contained in this tuber. It tastes surprisingly good, too. You could cook with it but any change in its pure state would only reduce its value.")
