minetest.register_craftitem("nc_woodmattock:mattockhead",{
    description = "Wooden Mattock Head",
    inventory_image = "woodenmattocktoolhead.png",
    stack_max = 1,
    groups = {
        flammable = 2,
    },
    tool_head_capabilities = nodecore.toolcaps({
            ["cracky"] = 2,
            ["crumbly"] = 2,
        }),
    sounds = nodecore.sounds("nc_tree_woody"),
})

minetest.register_tool("nc_woodmattock:mattock", {
    description = "Wooden Mattock",
    inventory_image = "woodmattock.png",
    groups = {
        flammable = 2,
        cracky = 2,
        crumbly = 2,
    },
    tool_capabilities = nodecore.toolcaps({
        ["cracky"] = 2,
        ["crumbly"] = 2,
    }),
    sounds = nodecore.sounds("nc_tree_woody"),
})

nodecore.register_craft({
    label = "assemble wood mattock",
    normal = {y = 1},
    indexkeys = {"nc_woodmattock:mattockhead"},
    nodes = {
        {match = "nc_woodmattock:mattockhead", replace = "air"},
        {y = -1, match =  "nc_woodwork:staff", replace = "air"},
    },
    items = {
        {y = -1, name = "nc_woodmattock:mattock"},
    }
})

nodecore.register_craft({
    label = "make mattock head",
    action = "pummel",
    toolgroups = {cracky = 3},
    consumewield = 1,
    indexkeys = {"nc_woodwork:toolhead_spade"},
    nodes = {
        {match = "nc_woodwork:toolhead_spade", replace = "air"}
    },
    items = {"nc_woodmattock:mattockhead",},
    
    duration = 5,
})

nodecore.register_craft({
    label = "assemble stone mattock",
    action = "stackapply",
    wield = {name = "nc_stonework:chip"},
    consumewield = 1,
    indexkeys = {"nc_woodmattock:mattock"},
    nodes = {{match = "nc_woodmattock:mattock", replace = "air", wear = 0.05}},
    items = {"nc_woodmattock:stonemattock"}
})

minetest.register_tool("nc_woodmattock:stonemattock", {
    description = "Stone-Tipped Mattock",
    inventory_image = "stonemattock.png",
    tool_wears_to = "nc_woodmattock:mattock",
    tool_capabilities = nodecore.toolcaps({
        ["cracky"] = 3,
        ["crumbly"] = 3,
    }),
    groups = {
        flammable = 2,      
    },
    sounds = nodecore.sounds("nc_terrain_stony"),
})