minetest.register_craftitem("nc_wooden_mattock:mattockhead",{
    description = "Wooden Mattock Head",
    inventory_image = "woodenmattocktoolhead.png",
    stack_max = 1,
    groups = {
        flammable = 2,
    },
    tool_head_capabilities = nodecore.toolcaps({
            ["cracky"] = 2,
            ["crumbly"] = 2,
        }),
    sounds = nodecore.sounds("nc_tree_woody"),
})

minetest.register_tool("nc_wooden_mattock:mattock", {
    description = "Wooden Mattock",
    inventory_image = "woodmattock.png",
    groups = {
        flammable = 2,
        cracky = 2,
        crumbly = 2,
    },
    tool_capabilities = nodecore.toolcaps({
        ["cracky"] = 2,
        ["crumbly"] = 2,
    }),
    sounds = nodecore.sounds("nc_tree_woody"),
})

nodecore.register_craft({
    label = "assemble wood mattock",
    normal = {y = 1},
    indexkeys = {"nc_wooden_mattock:mattockhead"},
    nodes = {
        {match = "nc_wooden_mattock:mattockhead", replace = "air"},
        {y = -1, match =  "nc_woodwork:staff", replace = "air"},
    },
    items = {
        {y = -1, name = "nc_wooden_mattock:mattock"},
    }
})

nodecore.register_craft({
    label = "make mattock head",
    action = "pummel",
    toolgroups = {cracky = 3},
    consumewield = 1,
    indexkeys = {"nc_woodwork:toolhead_spade"},
    nodes = {
        {match = "nc_woodwork:toolhead_spade", replace = "air"}
    },
    items = {"nc_wooden_mattock:mattockhead",},
    
    duration = 5,
})

nodecore.register_craft({
    label = "assemble stone mattock",
    action = "stackapply",
    wield = {name = "nc_stonework:chip"},
    consumewield = 1,
    indexkeys = {"nc_wooden_mattock:mattock"},
    nodes = {{match = "nc_wooden_mattock:mattock", replace = "air", wear = 0.05}},
    items = {"nc_wooden_mattock:stonemattock"}
})

minetest.register_tool("nc_wooden_mattock:stonemattock", {
    description = "Stone-Tipped Mattock",
    inventory_image = "stonemattock.png",
    tool_wears_to = "nc_wooden_mattock:mattock",
    tool_capabilities = nodecore.toolcaps({
        ["cracky"] = 3,
        ["crumbly"] = 3,
    }),
    groups = {
        flammable = 2,      
    },
    sounds = nodecore.sounds("nc_terrain_stony"),
})