-- Parameters for the biospheres
biosphere = {
	-- Spawn the players at the biospheres ? (no/singlenode_only/yes)
	spawn_at_biosphere = "singlenode_only",
	-- altitude of the center of the spheres. Only one layer of spheres vertically.
	altitude = 512,
	-- Radius of the sphere
	radius = 96,
	-- Distance between two biospheres
	period = 3 * 96,
	-- Each biosphere is inside a cube whose dimension is the period
	-- The center position is at the middle of the cube
	center = 3 * 96 / 2,
	-- Amplitude applied to the noise to generate the heightmap
	noise_amplitude = 40,
	-- Water level relative to the center of the sphere
	water_level = -5,
	-- Altitude of the water level for biome computation
	water_level_altitude = 10,
	-- Type of node for glass
	glass_node = "default:glass",
	-- Type of node for bridge
	bridge_node = "default:steelblock",
	-- Type of node for doors
	door_node = "doors:door_glass",
	--
	-- Load from settings
	load = function(self)
		local val = core.settings:get("biosphere.spawn_at_biosphere")
		if (val == "no") or (val == "yes") or (val == "singlenode_only") then
			self.spawn_at_biosphere = val
		end
		val = tonumber(core.settings:get("biosphere.altitude"))
		if val then
			self.altitude = val
		end
		val = tonumber(core.settings:get("biosphere.radius"))
		if val then
			self.radius = val
			self.period = 3 * self.radius
			self.center = self.period / 2
		end
		val = tonumber(core.settings:get("biosphere.noise_amplitude"))
		if val then
			self.noise_amplitude = val
		end
		val = tonumber(core.settings:get("biosphere.water_level"))
		if val then
			self.water_level = val
		end
		val = tonumber(core.settings:get("biosphere.water_level_altitude"))
		if val then
			self.water_level_altitude = val
		end
		val = core.settings:get("biosphere.glass_node")
		if val then
			self.glass_node = val
		end
		val = core.settings:get("biosphere.bridge_node")
		if val then
			self.bridge_node = val
		end
		val = core.settings:get("biosphere.door_node")
		if val then
			self.door_node = val
		end
	end,
	-- Translate a global coordinate into a local coordinate relative to the closest biosphere center
	local_x = function(self, x)
		return ((x + self.center) % self.period) - self.center
	end,
	local_y = function(self, y)
		return y - self.altitude
	end,
	local_z = function(self, z)
		return ((z + self.center) % self.period) - self.center
	end,
	-- Get the coordinate of the closest center
	center_x = function(self, x)
		return x - self:local_x(x)
	end,
	center_y = function(self, y)
		return self.altitude
	end,
	center_z = function(self, z)
		return z - self:local_z(z)
	end,
	-- Get the minimal altitude of the biosphere layer
	min_y = function(self)
		return self.altitude - self.radius - 2
	end,
	max_y = function(self)
		return self.altitude + self.radius + 2
	end,
	-- Get the distance to the closest center
	distance_to_center = function(self, x, y, z)
		return ((x - self:center_x(x))^2 + (y - self:center_y(y))^2 + (z - self:center_z(z))^2)^0.5
	end,
	-- Get the cylindrical distance to the closest center
	cylindrical_distance_to_center = function(self, x, y, z)
		return ((x - self:center_x(x))^2 + (z - self:center_z(z))^2)^0.5
	end,
	-- Translate a global altitude into the local altitude for biome computation purposes
	biome_altitude = function(self, y)
		local loc_y = self:local_y(y)
		return loc_y - self.water_level + self.water_level_altitude
	end,
	-- check if a position is inside a biosphere
	is_inside = function(self, x, y, z)
		-- Distance should be lower than the radius
		return self:distance_to_center(x, y, z) < self.radius
	end,
}
biosphere:load()
