-- Load the biosphere object
dofile(core.get_modpath(core.get_current_modname()) .. "/biosphere.lua")

-- Register the mapgen script
core.register_mapgen_script(core.get_modpath(core.get_current_modname()) .. "/mapgen.lua")

-- With singlenode generator, set a spawn function for the player instead of spawning at 0,0,0
local mg_name = core.get_mapgen_setting("mg_name")
if (biosphere.spawn_at_biosphere == "yes") or (biosphere.spawn_at_biosphere == "singlenode_only" and mg_name == "singlenode") then
	core.register_on_newplayer(function(player)
		player:set_pos({x=0, y=biosphere.altitude+1, z=biosphere.period/2})
	end)
end
