local S = minetest.get_translator(minetest.get_current_modname())

local disable_sounds = minetest.settings:get_bool("shields_disable_sounds")
local function play_sound_effect(player, name)
	if not disable_sounds and player then
		local pos = player:get_pos()
		if pos then
			minetest.sound_play(name, {
				pos = pos,
				max_hear_distance = 10,
				gain = 0.5,
			})
		end
	end
end

armor:register_armor(":3d_armor:atriumic_helmet", {
    description = S("Atriumic Helmet"),
    inventory_image = "3d_armor_inv_helmet_atriumic.png",
    groups = {armor_head=1, armor_heal=16, armor_use=350, armor_water=1},
    armor_groups = {fleshy=20},
    damage_groups = {cracky=2, snappy=1, choppy=1, level=3, fleshy=20},
})

armor:register_armor(":3d_armor:atriumic_chestplate", {
    description = S("Atriumic Chestplate"),
    inventory_image = "3d_armor_inv_chestplate_atriumic.png",
    groups = {armor_torso=1, armor_heal=16, armor_use=350},
    armor_groups = {fleshy=30},
    damage_groups = {cracky=2, snappy=1, choppy=1, level=3, fleshy=30},
})

armor:register_armor(":3d_armor:atriumic_leggings", {
    description = S("Atriumic Leggings"),
    inventory_image = "3d_armor_inv_leggings_atriumic.png",
    groups = {armor_legs=1, armor_heal=16, armor_use=350, physics_jump=0.5},
    armor_groups = {fleshy=25},
    damage_groups = {cracky=2, snappy=1, choppy=1, level=3, fleshy=25},
})

armor:register_armor(":3d_armor:atriumic_boots", {
    description = S("Atriumic Boots"),
    inventory_image = "3d_armor_inv_boots_atriumic.png",
    groups = {armor_feet=1, armor_heal=16, armor_use=350, physics_speed=1},
    armor_groups = {fleshy=15},
    damage_groups = {cracky=2, snappy=1, choppy=1, level=3, fleshy=15},

})

armor:register_armor(":shields:shield_atriumic", {
	description = S("Atriumic Shield"),
	inventory_image = "shields_inv_shield_atriumic.png",
	groups = {armor_shield=1, armor_heal=15, armor_use=75},
	armor_groups = {fleshy=16},
	damage_groups = {cracky=2, snappy=1, level=3, fleshy=16},
	reciprocate_damage = true,
	on_damage = function(player, index, stack)
		play_sound_effect(player, "default_glass_footstep")
	end,
	on_destroy = function(player, index, stack)
		play_sound_effect(player, "default_break_glass")
	end,
})
