local S = minetest.get_translator(minetest.get_current_modname())

minetest.register_tool("atriumic:atriumic_pickaxe",{
    description = S"Atriumic Pickaxe",
    inventory_image = "atriumic_pickaxe.png",
    tool_capabilities = {
        full_punch_interval = 2,
        max_drop_level = 1,
        groupcaps = {
            cracky = {
                maxlevel = 4,
                uses = 13480,
                times = { [1]=1.80, [2]=1.10, [3]=0.4 }
            },
        },
        damage_groups = {cracky=3},
    }

})

minetest.register_tool("atriumic:atriumic_sword",{
    description = S"Atriumic Sword",
    inventory_image = "atriumic_sword.png",
    tool_capabilities = {
        full_punch_interval = 0,3,
        max_drop_level = 1,
        groupcaps = {
		snappy = {
			times = {1.80, 110., 0.4},
			uses = 65536,
			maxlevel = 11
            },
        },
        damage_groups = {fleshy=80, snappy},
    },
})

minetest.register_tool("atriumic:atriumic_axe",{
    description = S"Atriumic Axe",
    inventory_image = "atriumic_axe.png",
    groups = {weapon = 1, sword = 1},
    tool_capabilities = {
        full_punch_interval = 1.5,
        max_drop_level = 1,
        groupcaps = {
            choppy = {
                maxlevel = 5,
                uses = 65536,
                times = { [1]=0.80, [2]=0.40, [3]=0.1 }
            },
        },
        damage_groups = {choppy=2},
    },
})

minetest.register_tool("atriumic:atriumic_shovel", {
    description = S"Atriumic Shovel",
    inventory_image = "atriumic_shovel.png",
    tool_capabilities = {
        full_punch_interval = 1.5,
        max_drop_level = 1,
        groupcaps = {
            crumbly = {
                maxlevel = 5,
                uses = 65536,
                times = { [1]=2.00, [2]=1.0, [3]=0.3 }
            },
        },
        damage_groups = {crumbly=2},
    },
})

