minetest.register_abm({
    label = "Grass spread",
    nodenames = {"atriumic:atriumic_dirt"},
    neighbors = {"air"},
    interval = 10,
    chance = 50,
    action = function(pos, node)
        pos.y = pos.y + 1
        local above = minetest.get_node(pos)
        if above.name == "air" then
            pos.y = pos.y - 1
            minetest.set_node(pos, {name = "atriumic:atriumic_dirt_with_grass"})
        end
    end
})

local function node_group_check(node, groups)
    for _, groupname in ipairs(groups) do
        if minetest.get_item_group(node.name, groupname) > 0 then
            return 1
        end
    end
    return 0
end

minetest.register_abm({
    label = "Grass dried, normal dirt",
    nodenames = {"atriumic:atriumic_dirt_with_grass"},
    neighbors = {"air"},
    interval = 10,
    chance = 50,
    action = function(pos, node, name)
        pos.y = pos.y + 1
        local above = minetest.get_node(pos)
        local allowedgroups = {"cracky","liquid","choppy","crumbly"}
        local disallowedgroups = {"fence"}
        if node_group_check(above, allowedgroups) > 0 and node_group_check(above, disallowedgroups) < 1 then
            pos.y = pos.y - 1
            minetest.set_node(pos, {name = "atriumic:atriumic_dirt"})
        end
    end
})