local S = minetest.get_translator(minetest.get_current_modname())

minetest.register_ore({
    ore_type       = "scatter",
    ore            = "atriumic:atriumic_ore",
    wherein        = "default:stone",
    clust_scarcity = (13 * 13 * 13),
    clust_num_ores = 4,
    clust_size     = 2,
    y_min          = -12000,
    y_max          = -3000,
})

minetest.register_node("atriumic:atriumic_ore",{
    description = S"Atriumic Ore",
    tiles = {"default_stone.png^atriumic_ore.png"},
    groups = {cracky = 1, level = 3},
    is_ground_content = true,
    drop = "atriumic:atriumic_lump",
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_craftitem("atriumic:atriumic_lump",{
    description = S"Atriumic Lump",
    inventory_image = "atriumic_lump.png",
})

minetest.register_craftitem("atriumic:atriumic_ingot",{
    description = S"Atriumic Ingot",
    inventory_image = "atriumic_ingot.png",
    stack_max = 64,
    groups = { craftitem = 1},
})

minetest.register_node("atriumic:atriumic_block",{
    description = S"Atriumic Block",
    tiles = {"atriumic_block.png"},
    groups = {cracky = 1, level = 3},
    drop = "atriumic:atriumic_block",
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("atriumic:atriumic_dirt",{
    description = S"Atriumic Dirt",
    tiles = {"atriumic_dirt.png"},
    groups = {soil = 1, crumbly = 3},
    drop = "atriumic:atriumic_dirt",
    sounds = default.node_sound_dirt_defaults(),
})

minetest.register_node("atriumic:atriumic_leaves",{
    drawtype = "allfaces_optional",
    description = S"Atriumic Leaves",
    tiles = {"atriumic_tree_leaves.png"},
    paramtype = "light",
    is_ground_content = false,
    groups = {snappy = 3, fleshy = 3, leafdecay = 3, flammable = 2, leaves = 1},
    drop = "atriumic:atriumic_leaves",
    sounds = default.node_sound_leaves_defaults(),
})

minetest.register_node("atriumic:atriumic_log",{
    description = S"Atriumic Tree",
    tiles = 	{
		"atriumic_tree_top.png",
	   	"atriumic_tree_bottom.png",
		"atriumic_tree_side.png",
		"atriumic_tree_side.png",
		"atriumic_tree_side.png",
		"atriumic_tree_side.png"
},
    paramtype2 = "facedir",
    is_ground_content = false,
    groups = {tree = 1, oddly_breakable_by_hand = 1, choppy = 1,},
    drop = "atriumic:atriumic_log",
    sounds = default.node_sound_wood_defaults(),
})

minetest.register_craftitem("atriumic:atriumic_stick",{
    description = S"Atriumic Stick",
    inventory_image = "atriumic_stick.png",
    stack_max = 64,
    groups = { craftitem = 1, stick = 1},
})

minetest.register_node("atriumic:atriumic_planks",{
    description = S"Atriumic Planks",
    tiles = 	{"atriumic_planks.png",},
    groups = {oddly_breakable_by_hand = 1, choppy = 1, wood = 1},
    drop = "atriumic:atriumic_planks",
    sounds = default.node_sound_wood_defaults(),
})

minetest.register_node("atriumic:atriumic_dirt_with_grass",{
    description = S"Atriumic Dirt With Grass",
    tiles = {
		"atriumic_dirt_with_grass_top.png",
		"atriumic_dirt_with_grass_bottom.png",
		"atriumic_dirt_with_grass_side.png",
		"atriumic_dirt_with_grass_side.png",
		"atriumic_dirt_with_grass_side.png",	
		"atriumic_dirt_with_grass_side.png",
},
    groups = {soil = 1, crumbly = 3, },
    drop = "atriumic:atriumic_dirt",
    sounds = default.node_sound_dirt_defaults(),
})


for r = 1, 5 do
	minetest.register_node("atriumic:atriumic_grass_" .. r, {
		description = S("Atriumic Grass"),
		drawtype = "plantlike",
		waving = 1,
		tiles = {"atriumic_grass_" .. r .. ".png"},
		inventory_image = "atriumic_grass_" .. r .. ".png",
		wield_image = "atriumic_grass_" .. r .. ".png",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		buildable_to = true,
		drop = "default:grass_1",
		groups = {snappy = 3, flora = 1, attached_node = 1, grass = 1, normal_grass = 1, flammable = 1},
		sounds = default.node_sound_leaves_defaults(),
		selection_box = {
			type = "fixed",
			fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, -3 / 16, 6 / 16},
		},

		on_place = function(itemstack, placer, pointed_thing)
			local stack = ItemStack("atriumic:atriumic_grass_" .. r)
			local ret = minetest.item_place(stack, placer, pointed_thing)
			return ItemStack("atriumic:atriumic_grass_1 " ..
				itemstack:get_count() - (1 - ret:get_count()))
		end,
	})
end

minetest.register_node("atriumic:atriumic_deco_block_blue", {
	description = S"Blue Atriumic Decoration Block",
	tiles = {"atriumic_decoration_block_blue.png"},
	groups = {cracky = 1},
	--drop = "atriumic:atriumic_deco_block_blue",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("atriumic:atriumic_deco_block_red", {
	description = S"Red Atriumic Decoration Block",
	tiles = {"atriumic_decoration_block_red.png"},
	groups = {cracky = 1},
	--drop = "atriumic:atriumic_deco_block_red",
	sounds = default.node_sound_stone_defaults(),
})






