minetest.register_node("bin:default_bin", {
	description = ("Bin"),
	drawtype = "nodebox",
	tiles = {"default_stone_brick.png"},
    drop = ("bin:default_bin"),
	is_ground_content = true,
	stack_max = 16,
	groups = {
		handy = 1, deco_block = 1, destroys_items=1
	},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	paramtype = "light",
	node_placement_prediction = "",
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5,   -0.5, -0.5,  -0.375, 0.5,   0.5},   -- Left wall
			{ 0.375, -0.5, -0.5,   0.5,   0.5,   0.5},   -- Right wall
			{-0.375, -0.5,  0.375, 0.375, 0.5,   0.5},   -- Back wall
			{-0.375, -0.5, -0.5,   0.375, 0.5,  -0.375}, -- Front wall
			{-0.5,   -0.5, -0.5,   0.5,   -0.45, 0.5},   -- Bottom level
		}
	},
	_mcl_blast_resistance = 0.4,
	_mcl_hardness = 0.4,
})


minetest.register_craft({
	output = "bin:default_bin",
	recipe = {
		{"mcl_core:stonebrick", "", "mcl_core:stonebrick"},
		{"mcl_core:stonebrick", "mcl_buckets:bucket_lava", "mcl_core:stonebrick"},
		{"mcl_core:stonebrick", "mcl_core:stonebrick", "mcl_core:stonebrick"}
	},
    replacements = {
		{"mcl_buckets:bucket_lava", "mcl_buckets:bucket_empty"},
	},
})
