local mod = minetest.get_modpath("chimney")





--chimney_box_function

local function chimney_get_nodeboxes(level)
	return {
		type = "fixed",
		fixed = {
			{-0.5,   -0.5, -0.5,  -0.375, 0.5,   0.5},   -- Left wall
			{ 0.375, -0.5, -0.5,   0.5,   0.5,   0.5},   -- Right wall
			{-0.375, -0.5,  0.375, 0.375, 0.5,   0.5},   -- Back wall
			{-0.375, -0.5, -0.5,   0.375, 0.5,  -0.375}, -- Front wall
		}
	}
end






chimney = {
	longdesc = ("A Chimney for smoke."),
	elements = {
		chimney = {
			name = "chimney",
			description = "Chimney",
			index = 2,
			tiles = {
				"chimney_top.png",
				"chimney_bottom.png",
				"chimney_side.png"
			},
			craft = function(m)
				return {
					{ m, "",  m},
					{ m, "",  m},
					{ m, "",  m},
				}
			end,
		    paramtype = "light",
		    drawtype = "nodebox",
		    node_box = chimney_get_nodeboxes(0),
		    selection_box = {type = "regular"},
		    is_ground_content = false,
		    groups = {
		    	handy=1, material_stone=1, deco_block=1, dirtifier=1,
		    },
		    _mcl_hardness = 0.6,
		    _mcl_blast_resistance = 0.6,
			
		},

	},
}

function chimney.register_chimney(def)
	local modname = minetest.get_current_modname()
	local descriptions = def.descriptions or {}
	local groups = def.groups or {}
	local element_groups = def.element_groups or {}

	for name, element in pairs(chimney.elements) do
		local itemname = element.name .. "_" .. def.name
		local itemstring = modname .. ":" .. itemname

		local groups = table.copy(groups)
		groups.handy=1
		groups.material_stone=1
		groups.deco_block=1
		groups.dirtifier=1

		for k, v in pairs(element_groups) do
			groups[k] = v
		end

		minetest.register_node(itemstring, {
			description = (def.description .. " " .. (descriptions[name] or element.description)),
			_doc_items_longdesc = chimney.longdesc,
			_doc_items_usagehelp = chimney.usage,
			groups = groups,
			_mcl_chimney_element = name,
			tiles = {
				def.texture
			},
			_mcl_hardness = 0.6,
		    _mcl_blast_resistance = 0.6,
			paramtype = "light",
		    drawtype = "nodebox",
		    node_box = chimney_get_nodeboxes(0),
		    selection_box = {type = "regular"},
		    is_ground_content = false,
			sounds = mcl_sounds.node_sound_stone_defaults(),
		})

		if def.craft_material then
			minetest.register_craft({
				output = itemstring.. " 6",
				recipe = element.craft(def.craft_material),
			})
		end
	end
end








--chimney_roof_plate_box_function

local function chimney_roof_plate_get_nodeboxes(level)
	return {
		type = "fixed",
		fixed = {
			{-0.5,   -0.5, -0.5,  -0.375, 0,   0.5},   -- Left wall
			{ 0.375, -0.5, -0.5,   0.5,   0,   0.5},   -- Right wall
			{-0.375, -0.5,  0.375, 0.375, 0,   0.5},   -- Back wall
			{-0.375, -0.5, -0.5,   0.375, 0,  -0.375}, -- Front wall

			{-0.375, -0, 0.375, 0.375, 0.5,     0.5},   -- Back pillar
			{-0.375, -0, -0.5,   0.375, 0.5,  -0.375}, -- Front pillar

			{-0.5,   0.5, -0.5,   0.5,   0.4, 0.5},
		}
	}
end






chimney_roof_plate = {
	longdesc = ("A Chimney Roof Plate for smoke."),
	elements = {
		chimney = {
			name = "chimney_roof_plate",
			description = "Chimney Roof Plate",
			index = 2,
			craft = function(m)
				return {
					{"mcl_stairs:slab_stone_rough"},
					{m},
				}
			end,
		    paramtype = "light",
		    drawtype = "nodebox",
		    node_box = chimney_roof_plate_get_nodeboxes(0),
		    selection_box = {type = "regular"},
		    is_ground_content = false,
		    groups = {
		    	handy=1, material_stone=1, deco_block=1, dirtifier=1,
		    },
		    _mcl_hardness = 0.6,
		    _mcl_blast_resistance = 0.6,
			
		},

	},
}

function chimney.register_chimney_roof_plate(def)
	local modname = minetest.get_current_modname()
	local descriptions = def.descriptions or {}
	local groups = def.groups or {}
	local element_groups = def.element_groups or {}

	for name, element in pairs(chimney_roof_plate.elements) do
		local itemname = element.name .. "_" .. def.name
		local itemstring = modname .. ":" .. itemname

		local groups = table.copy(groups)
		groups.handy=1
		groups.material_stone=1
		groups.deco_block=1
		groups.dirtifier=1

		for k, v in pairs(element_groups) do
			groups[k] = v
		end

		minetest.register_node(itemstring, {
			description = (def.description .. " " .. (descriptions[name] or element.description)),
			_doc_items_longdesc = chimney_roof_plate.longdesc,
			_doc_items_usagehelp = chimney_roof_plate.usage,
			groups = groups,
			_mcl_chimney_roof_plate_element = name,
			tiles = {
				def.texture
			},
			_mcl_hardness = 0.6,
		    _mcl_blast_resistance = 0.6,
			paramtype = "light",
		    drawtype = "nodebox",
		    node_box = chimney_roof_plate_get_nodeboxes(0),
		    selection_box = {type = "regular"},
		    is_ground_content = false,
			sounds = mcl_sounds.node_sound_stone_defaults(),
		})

		if def.craft_material then
			minetest.register_craft({
				output = itemstring.. "",
				recipe = element.craft(def.craft_material),
			})
		end
	end
end










dofile(mod .. "/chimneys.lua")

dofile(mod .. "/chimney_roof_plates.lua")
