chimney = {}

function chimney.get_nodebox(node)

    if node == "chimney" then
        return {
            type = "fixed",
            fixed = {
                {-0.5,   -0.5, -0.5,  -0.375, 0.5,   0.5},
                { 0.375, -0.5, -0.5,   0.5,   0.5,   0.5},
                {-0.375, -0.5,  0.375, 0.375, 0.5,   0.5},
                {-0.375, -0.5, -0.5,   0.375, 0.5,  -0.375},
            }
        }
    end

    if node == "chimney_roof_plate" then
        return {
            type = "fixed",
            fixed = {
                {-0.5,   -0.5, -0.5,  -0.375, 0,   0.5},
                { 0.375, -0.5, -0.5,   0.5,   0,   0.5},
                {-0.375, -0.5,  0.375, 0.375, 0,   0.5},
                {-0.375, -0.5, -0.5,   0.375, 0,  -0.375},

                {-0.375, -0, 0.375, 0.375, 0.5,     0.5},
                {-0.375, -0, -0.5,   0.375, 0.5,  -0.375},

                {-0.5,   0.5, -0.5,   0.5,   0.4, 0.5},
            }
        }
    end

    if node == "chimney_trim" then
        return {
            type = "fixed",
            fixed = {
                {-0.5, -0.5, -0.5, -0.375, 0.5, 0.5},
                {-0.375, -0.5, 0.375, 0.375, 0.5, 0.5},
                {-0.375, -0.5, -0.5, 0.375, 0.5, -0.375},
                {0.375, -0.5, -0.5, 0.5, 0.5, 0.5},
                {-0.5625, 0.3125, -0.5625, -0.5, 0.375, 0.5625},
                {0.5, 0.3125, -0.5625, 0.5625, 0.375, 0.5625},
                {-0.5, 0.3125, -0.5625, 0.5, 0.375, -0.5},
                {-0.5, 0.3125, 0.5, 0.5, 0.375, 0.5625},
                {-0.5, 0, 0.5, 0.5, 0.0625, 0.5625},
                {-0.5, 0, -0.5625, 0.5, 0.0625, -0.5},
                {0.5, 0, -0.5625, 0.5625, 0.0625, 0.5625},
                {-0.5625, 0, -0.5625, -0.5, 0.0625, 0.5625},
                {-0.625, 0.1875, -0.625, 0.625, 0.3125, -0.5},
                {-0.625, 0.1875, 0.5, 0.625, 0.3125, 0.625},
                {0.5, 0.1875, -0.5, 0.625, 0.3125, 0.5},
                {-0.625, 0.1875, -0.5, -0.5, 0.3125, 0.5},
            }
        }
    end
end








function chimney.register_chimney(def)

    itemstring = "chimney" .. ":" .. "chimney_" .. def.name

    minetest.register_node(itemstring, {
        description = (def.description .. " Chimney"),
        _doc_items_longdesc = "A hollow node that allows smoke to pass through.",
        _doc_items_usagehelp = "Place the chimney over a campfire.",
        groups = {handy=1, material_stone=1, deco_block=1, dirtifier=1},
        tiles = {
            def.texture
        },
        _mcl_hardness = 0.6,
        _mcl_blast_resistance = 0.6,
        paramtype = "light",
        drawtype = "nodebox",
        node_box = chimney.get_nodebox("chimney"),
        selection_box = {type = "regular"},
        is_ground_content = false,
        sounds = mcl_sounds.node_sound_stone_defaults(),
    })


    minetest.register_craft({
        output = itemstring.. " 6",
        recipe = {
            {def.craft_material, "", def.craft_material},
            {def.craft_material, "", def.craft_material},
            {def.craft_material, "", def.craft_material},
        },
    })

end

function chimney.register_chimney_roof_plate(def)

    itemstring = "chimney" .. ":" .. "chimney_roof_plate_" .. def.name

    minetest.register_node(itemstring, {
        description = (def.description .. " Chimney roof plate"),
        _doc_items_longdesc = "A hollow node that allows smoke to pass through.",
        _doc_items_usagehelp = "Place the chimney over a campfire.",
        groups = {handy=1, material_stone=1, deco_block=1, dirtifier=1},
        tiles = {
            def.texture
        },
        _mcl_hardness = 0.6,
        _mcl_blast_resistance = 0.6,
        paramtype = "light",
        drawtype = "nodebox",
        node_box = chimney.get_nodebox("chimney_roof_plate"),
        selection_box = {type = "regular"},
        is_ground_content = false,
        sounds = mcl_sounds.node_sound_stone_defaults(),
    })


    minetest.register_craft({
        output = itemstring,
        recipe = {
            {"mcl_stairs:slab_stone_rough"},
            {def.craft_material},
        },
    })

end

function chimney.register_chimney_trim(def)

    itemstring = "chimney" .. ":" .. "chimney_trim_" .. def.name

    minetest.register_node(itemstring, {
        description = (def.description .. " Chimney Trim"),
        _doc_items_longdesc = "A hollow node that allows smoke to pass through.",
        _doc_items_usagehelp = "Place the chimney over a campfire.",
        groups = {handy=1, material_stone=1, deco_block=1, dirtifier=1},
        tiles = {
            def.texture
        },
        _mcl_hardness = 0.6,
        _mcl_blast_resistance = 0.6,
        paramtype = "light",
        drawtype = "nodebox",
        node_box = chimney.get_nodebox("chimney_trim"),
        selection_box = {type = "regular"},
        is_ground_content = false,
        sounds = mcl_sounds.node_sound_stone_defaults(),
    })


    minetest.register_craft({
        output = itemstring.. " 6",
        recipe = {
            {def.craft_material, def.craft_material, def.craft_material},
            {def.craft_material, "", def.craft_material},
            {def.craft_material, "", def.craft_material},
        },
    })

end










dofile(minetest.get_modpath("chimney") .. "/register.lua")
