click_speed_detector = {}
click_speed_detector.last_place_times = {}

minetest.register_on_placenode(function(pos, newnode, player, oldnode, itemstack, pointed_thing)
    local player_name = player:get_player_name()

    local now = minetest.get_us_time()
    local last_place_time = click_speed_detector.last_place_times[player_name] or 0

    if now - last_place_time < 160000 then
        minetest.set_node(pos, oldnode)
        return itemstack
    end

    click_speed_detector.last_place_times[player_name] = now
end)
