## Functions

- **gs_cfg.new**

  Returns a new, empty CFG structure.

- **gs_cfg.load**

  file_path -> Path to a text file.

  Returns a CFG structure with the values stored in the specified text file.

- **cfg:set_value**

  section -> A section name.

  key -> A key string.

  value -> Any supported value.

  Assigns a value to a key in a section.

- **cfg:get_value**

  section -> A section name.

  key -> A key string.

  Returns the value of a key from a section.

- **cfg:save**

  file_path -> Path to a text file.

  Writes the CFG structure to a CFG text file.

- **cfg:get_sections**

  Returns all section names as strings in an table.

- **cfg:has_section**

  section -> A section name.

  Returns whether a section exists.

- **cfg:has_key**

  section -> A section name.

  key -> A key string.

  Returns whether a key exists in a section.

- **cfg:delete_section**

  section -> A section name.

  Deletes an entire section with all its keys.

- **cfg:delete_key**

  section -> A section name.

  key -> A key string.

  Deletes a key.

- **cfg:get_keys**

  section -> A section name.

  Returns all key names from a section as strings in an table.

- **cfg:clear**

  Removes everything from a CFG structure.

- **cfg:to_string**

  Returns the entire CFG structure as a human-readable string.

- **cfg:get_type**

  section -> A section name.

  key -> A key string.
  
  Returns the type of a value.



## Supported value types

- **String**
- **Number**
- **Boolean**
- **Nil**
- **Table**