local formspec_escape = minetest.formspec_escape
local show_formspec = minetest.show_formspec
local C = minetest.colorize
local text_color = "#313131"
local itemslot_bg = mcl_formspec.get_itemslot_bg

mineclonefood_ice_cream_maker = {}

function mineclonefood_ice_cream_maker.show_making_form(player)
	player:get_inventory():set_width("make", 3)
	player:get_inventory():set_size("make", 9)

	show_formspec(player:get_player_name(), "main",
		"size[9,8.75]".. 
		"image[4.7,1.5;1.5,1;gui_crafting_arrow.png]"..
		"label[0,4;"..formspec_escape(C(text_color, ("Inventory"))).."]"..
		"list[current_player;main;0,4.5;9,3;9]"..
		itemslot_bg(0,4.5,9,3)..
		"list[current_player;main;0,7.74;9,1;]"..
		itemslot_bg(0,7.74,9,1)..
		"label[1.75,0;"..formspec_escape(C(text_color, ("Ice cream maker"))).."]"..
		"list[current_player;make;1.75,0.5;3,3;]"..
		itemslot_bg(1.75,0.5,3,3)..
		"list[current_player;makepreview;6.1,1.5;1,1;]"..
		itemslot_bg(6.1,1.5,1,1)..
		"listring[current_player;main]"..
		"listring[current_player;craft]"
	)
end

minetest.register_node("mineclonefood:ice_cream_maker", {
	description = ("Ice cream maker"),
	_doc_items_longdesc = ("An ice cream maker"),
	_doc_items_usagehelp = ("Rightclick the Ice cream maker to make ice cream."),
	_doc_items_hidden = false,
	is_ground_content = false,
	tiles = {"ice_cream_maker_top.png", "ice_cream_maker_ground.png", "ice_cream_maker_side.png",
		"ice_cream_maker_side.png", "ice_cream_maker_side.png", "ice_cream_maker_side.png"},
	paramtype2 = "facedir",
	groups = {handy=1,axey=1, deco_block=1, material_stone=1},
	on_rightclick = function(pos, node, player, itemstack)
		if not player:get_player_control().sneak then
			mineclonefood_ice_cream_maker.show_making_form(player)
		end
	end,
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 2.5,
	_mcl_hardness = 2.5,
})
