local S = minetest.get_translator(minetest.get_current_modname())

local modpath = minetest.get_modpath("mineclonefood")
dofile(modpath .. "/crafting.lua")

if minetest.registered_nodes["mcl_trees:leaves_cherry_blossom"] then
	table.insert(minetest.registered_nodes["mcl_trees:leaves_cherry_blossom"].drop.items, {items = {"mineclonefood:cherry"}, rarity = 8})
end

if minetest.registered_nodes["mcl_cherry_blossom:cherryleaves"] then
	table.insert(minetest.registered_nodes["mcl_cherry_blossom:cherryleaves"].drop.items, {items = {"mineclonefood:cherry"}, rarity = 8})
end

awards.register_achievement("mineclonefood:cherry_eating", {
	title = S("Don't smack your lips like that!"),
	icon = "mineclonefood_cherry.png",
	description = S("Eat a Cherry."),
	trigger = {
		type = "eat",
		item = "mineclonefood:cherry",
		target = 1,
	}
})

minetest.register_craftitem("mineclonefood:cherry", {
	description = S("Cherry"),
	inventory_image = "mineclonefood_cherry.png",
	groups = {food = 2, eatable = 2},
	_mcl_saturation = 0.6,
	on_place = minetest.item_eat(2),
	on_secondary_use = minetest.item_eat(2),
})

minetest.register_craftitem("mineclonefood:cherryjuce", {
	description = S("Cherry Juice"),
	inventory_image = "mineclonefood_cherryjuce.png",
	stack_max = 1,
	groups = {food = 3, eatable = 4},
	_mcl_saturation = 1.2,
	on_place = function(itemstack, user, pointed_thing)
		if user and user:is_player() then
			mcl_potions.give_effect_by_level("slow_falling", user, 1, 4, false)
		end
		return minetest.do_item_eat(4, "mcl_potions:glass_bottle", itemstack, user, pointed_thing)
	end,
	on_secondary_use = function(itemstack, user, pointed_thing)
		if user and user:is_player() then
			mcl_potions.give_effect_by_level("slow_falling", user, 1, 4, false)
		end
		return minetest.do_item_eat(4, "mcl_potions:glass_bottle", itemstack, user, pointed_thing)
	end,
})

minetest.register_craftitem("mineclonefood:cherry_cake", {
	description = S("Cherry Cake"),
	inventory_image = "mineclonefood_cherrycake.png",
	groups = {food = 2, eatable = 7},
	_mcl_saturation = 1.6,
	on_place = minetest.item_eat(7),
	on_secondary_use = minetest.item_eat(7),
})

minetest.register_craftitem("mineclonefood:cherrysugar", {
	description = S("Cherry Sugar"),
	inventory_image = "mineclonefood_cherrysugar.png",
	groups = {food = 2, eatable = 2},
	_mcl_saturation = 0.4,
	on_place = minetest.item_eat(2),
	on_secondary_use = minetest.item_eat(2),
})

minetest.register_craftitem("mineclonefood:cherryloly", {
	description = S("Cherry Lolly"),
	inventory_image = "mineclonefood_cherryloly.png",
	groups = {food = 2, eatable = 3},
	_mcl_saturation = 0.8,
	on_place = minetest.item_eat(3),
	on_secondary_use = minetest.item_eat(3),
})

minetest.register_craftitem("mineclonefood:sandcake", {
	description = S("Sandcake"),
	inventory_image = "mineclonefood_sandcake.png",
	groups = {food = 2, eatable = 8},
	_mcl_saturation = 2.0,
	on_place = minetest.item_eat(8),
	on_secondary_use = minetest.item_eat(8),
})

minetest.register_craftitem("mineclonefood:firecake", {
	description = S("Firecake"),
	inventory_image = "mineclonefood_firecake.png",
	groups = {food = 2, eatable = 8},
	_mcl_saturation = 2.4,
	on_place = function(itemstack, user, pointed_thing)
		if user and user:is_player() then
			mcl_potions.give_effect_by_level("fire_resistance", user, 1, 16, false)
		end
		return minetest.do_item_eat(8, nil, itemstack, user, pointed_thing)
	end,
	on_secondary_use = function(itemstack, user, pointed_thing)
		if user and user:is_player() then
			mcl_potions.give_effect_by_level("fire_resistance", user, 1, 16, false)
		end
		return minetest.do_item_eat(8, nil, itemstack, user, pointed_thing)
	end,
})

minetest.register_craftitem("mineclonefood:sunfloweroil", {
	description = S("Sunflower Oil"),
	inventory_image = "mineclonefood_sunfloweroil.png",
	groups = {craftitem = 1},
	stack_max = 64,
})

minetest.register_craftitem("mineclonefood:cherrybonbon", {
	description = S("Cherry Bonbon"),
	inventory_image = "mineclonefood_cherrybonbon.png",
	groups = {food = 2, eatable = 3},
	_mcl_saturation = 0.8,
	on_place = minetest.item_eat(3),
	on_secondary_use = minetest.item_eat(3),
})

minetest.register_craftitem("mineclonefood:cherry_icecream", {
	description = S("Cherry Icecream"),
	inventory_image = "mineclonefood_cherry_icecream.png",
	groups = {craftitem = 1, food = 3, eatable = 5},
	on_place = minetest.item_eat(5, "mcl_core:bowl"),
	on_secondary_use = minetest.item_eat(5, "mcl_core:bowl"),
	_mcl_saturation = 1.2,
	stack_max = 1,
})

minetest.register_craftitem("mineclonefood:sweet_berry_icecream", {
	description = S("Sweet Berry Icecream"),
	inventory_image = "mineclonefood_sweet_berry_icecream.png",
	groups = {craftitem = 1, food = 3, eatable = 5},
	on_place = minetest.item_eat(5, "mcl_core:bowl"),
	on_secondary_use = minetest.item_eat(5, "mcl_core:bowl"),
	_mcl_saturation = 1.2,
	stack_max = 1,
})

minetest.register_craftitem("mineclonefood:roasted_potatoes", {
	description = S("Roasted Potatoes"),
	inventory_image = "mineclonefood_roasted_potatoes.png",
	groups = {food = 2, eatable = 6},
	_mcl_saturation = 1.6,
	on_place = minetest.item_eat(6),
	on_secondary_use = minetest.item_eat(6),
})
