# PostgresConnection (Lua/Minetest)

A simple Lua wrapper for PostgreSQL using a C library (`luapg.so`) for Minetest.

## Overview

`PostgresConnection` provides methods to:

- Connect to a PostgreSQL database
- Execute queries (`INSERT`, `UPDATE`, `DELETE`)
- Perform `SELECT` queries
- Escape values or identifiers safely for SQL statements

## Functions

### `PostgresConnection.new(host, dbname, user, password)`

Creates a new connection to a PostgreSQL database.

**Returns:**  
- `PostgresConnection` object on success  
- `nil, error_message` on failure  

### `PostgresConnection.new_from_conf(config_path)`

Creates a new connection using a configuration file.

**Returns:**  
- `PostgresConnection` object on success  
- `nil, error_message` if config file is missing or empty  

### `PostgresConnection:execute(query)`

Executes a non-select SQL query (`INSERT`, `UPDATE`, `DELETE`, etc.).

**Returns:**  
- `true` on success  
- `false, error_message` on failure  

### `PostgresConnection:select(query)`

Executes a `SELECT` query and returns the resulting rows.

**Returns:**  
- `table` of rows on success  
- `nil, error_message` on failure  

### `PostgresConnection:escape(text, escaping_type)`

Escapes a string or identifier for safe usage in SQL queries.  

**Parameters:**  
- `text` (string) – the value or identifier to escape  
- `escaping_type` (string) – `"value"` for SQL values, `"identifier"` for table/column names (defaults to `"value"` if invalid)  

**Returns:**  
- Escaped string on success  
- `nil, error_message` on failure
