local S = minetest.get_translator("goblins")
local function variance(min,max)
  local target = math.random(min,max) / 100
  --print(target)
  return target
 end

local gob_name_parts = goblins.gob_name_parts

goblins.gobdog_types = {
  gobdog = {
    owner_loyal = true,
    attack_npcs = false,
    -- attacks_monsters = false,
    group_attack = true,
    attack_players = true,
  },
  gobdog_aggro = {
    description = S("Dire Gobdog"),
    lore = S("Dire Gobdogs are sensitive to light and are very territorial"),
    type = "monster",
    group_attack = true,
    owner_loyal = true,
    attack_npcs = false,
    --attacks_monsters = false,
    attack_players = true,

    spawning = goblins.db_read("gobdog_aggro_spawning")
  },
}
-------------
-- Gobdog Template
------------
local function chose_one(from_list)
  local choice = ""

end
goblins.gobdog_template = {
  description = S("Gobdog"),
  lore =  S("Gobdogs are not canids but goblins that have mutated somehow, fortunately they do not share the hunger and size of the mythical werewolf."),
  type = "npc",
  spawn_class = "hostile",
  attack_type = "dogfight",
  group_attack = true,
  reach = 2,
  damage = 1,
  hp_min = 2,
  hp_max = 5,
  armor = 100,
  stepheight = 1.2,
  walk_velocity = goblins.comp.gobdef.walk_velocity,
  run_velocity = goblins.comp.gobdef.run_velocity + 1,
  jump = true,
  jump_height = 6,
  pushable = true,
  knock_back = true,
  view_range = 15,
  water_damage = 0,
  lava_damage = 5,
  light_damage = 0,
  fear_height = 4,
  floats = 1,
  --glow = 1,
  pathfinding = 1,
  stay_near = {
    "group:water", 20,
    "group:sand", 20,
    "group:soil", 20,
    goblins.comp.default.mossycobble, 10,
    "group:meat" ,2,
    "goblins:goblins_goblin_bone_meaty"},
  collisionbox = {-0.45, -0.01, -0.45, 0.45, 0.85, 0.45},
  visual = "mesh",
  mesh = "goblins_goblin_dog.b3d",
  textures = {
    {"goblins_goblin_dog.png"},
  },
  makes_footstep_sound = true,
  sounds = {
    random = "goblins_goblin_dog_ambient_cave",
    war_cry = "goblins_goblin_dog_war_cry_cave",
    attack = "goblins_goblin_dog_attack_cave",
    damage = "goblins_goblin_dog_damage_cave",
    death = "goblins_goblin_dog_death_cave",
    replace = "goblins_goblin_dog_replace_cave",gain = 0.8,
    eat = "goblins_goblin_dog_replace_cave",
  },
  follow = goblins.db_read("gobdog_follow"),
  drops = goblins.db_read("gobdog_drops"),
  animation = {
    speed_normal = 60,
    stand_start = 0,
    stand_end = 60,
    walk_start = 70,
    walk_end = 90,
    run_start = 130,
    run_end = 140,
    run_speed =30,
    jump_start = 160,
    jump_end = 190,
    jump_loop = true,
    jump_speed = 30,
    punch_start = 130,
    punch_end = 140,
    punch_speed = 30,
    die_start = 140,
    die_stop = 145,
    die_speed = 30,
    die_loop = false,
  },

  on_spawn = function(self)
    minetest.sound_play("goblins_goblin_dog_war_cry_cave", {
      object = self.object,
      gain = .5,
      max_hear_distance =30
    })
    self.groups = {"gobdog", "goblin"}
    self.groups_defend = {"goblin","gobdog","gobdog_friend"}
    if not self.secret_name then
      local name_rules = {"list_a", "list_opt"}
      self.secret_name = goblins.generate_name(gob_name_parts, name_rules)
    end
    --print (dump(self.secret_name))
    local pos = vector.round(self.object:get_pos())
    if not pos then return end
    if not self.secret_territory then
      local territory = {goblins.territory(pos)}
      self.secret_territory = {name = territory[1], vol = territory[2]}
      --print(dump(self.secret_territory.name).." secret_territory assigned")
    else
    --print(dump(self.secret_territory.name).." secret_territory already assigned")
    end
    local color_var = "#"..math.random(10,50)..math.random(10,50)..math.random(10,50)
    --print("COLOR_VAR: "..color_var)
    self.object:set_texture_mod("^[colorize:"..color_var..":80")

    if not self.size then
      local s_mod = variance(1,20)
      self.size = vector.new((variance(90,100) - s_mod), (variance(80,110) - s_mod), (variance(90,100) - s_mod))
    end

    local self_properties = self.object:get_properties()
    self_properties.visual_size = self.size
    self.object:set_properties(self_properties)
    goblins.announce_spawn(self)
  end,

  on_rightclick = function(self, clicker)
    local pos = vector.round(self.object:get_pos())
    goblins.goblin_dog_rightclick(self, clicker)
    if math.random(5) == 1 then
      minetest.sound_play("goblins_goblin_dog_attack_cave", {
        pos = pos,
        gain = math.random(4,8)/10,
        pitch = math.random(12,14)/10,
        max_hear_distance = self.sounds.distance or 10
       })
    else
    minetest.sound_play("goblins_goblin_dog_replace_cave", {
      pos = pos,
      gain = math.random(8,10)/10,
      pitch = math.random(10,14)/10,
      max_hear_distance = self.sounds.distance or 10
     })
    end
  end,

  ---dog behaviors or not...
  do_custom = function(self)
    goblins.goblin_dog_behaviors(self)
  end,

  do_punch = function(self,hitter)
    local pname = hitter:get_player_name()
    local relations = goblins.relations(self, pname)
    if not relations.aggro then
       goblins.relations(self, pname, {aggro = 0})
       relations = goblins.relations(self, pname)
    end
    --print(self.secret_name.." relations on click:\n"..dump(self.relations).."\n")
    if self.relations[pname].aggro then
       local adj = (self.relations[pname].aggro + 1) * 1.5
       self.relations[pname].aggro = math.floor(adj)
       goblins.relations(self, pname, {aggro = self.relations[pname].aggro} )
    end
  end,

  spawning = goblins.db_read("gobdog_spawning")
}
--[[
mobs:alias_mob("goblins:goblins_goblin_dog", "goblins:goblin_gobdog")
mobs:alias_mob("goblins:goblin_goblin_dog", "goblins:goblin_gobdog")

mobs:alias_mob("goblins:goblins_goblin_dog_aggro", "goblins:goblin_gobdog_aggro")
mobs:alias_mob("goblins:goblin_goblin_dog_aggro", "goblins:goblin_gobdog_aggro")
]]
