
-- alter this file to adjust goblin/gobdog spawning
-- it may be overwritten on update so be sure to back up your changes
-- or use a custom file (explained at the bottom)

goblins.spawning = {
  digger = {
      nodes = {"group:stone"},
      neighbors = "air",
      min_light = 0,
      max_light = 10,
      interval = 30,
      chance = 1000,
      active_object_count = 2,
      min_height = -31000,
      max_height = -15,
      day_toggle = nil,
      on_spawn = nil,
  },
  cobble = {
    nodes = {"group:stone"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 30,
    chance = 1000,
    active_object_count = 2,
    min_height = -31000,
    max_height = -15,
    day_toggle = nil,
    on_spawn = nil,
  },
  snuffer = {
    nodes = {"default:mossycobble"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 30,
    chance = 1000,
    active_object_count = 2,
    min_height = -31000,
    max_height = -15,
    day_toggle = nil,
    on_spawn = nil,
  },
  fungiler = {
    nodes = {"default:mossycobble"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 30,
    chance = 1500,
    active_object_count = 1,
    min_height = -31000,
    max_height = -15,
    day_toggle = nil,
    on_spawn = nil,
  },
  coal = {
    nodes = {"default:stone_with_coal", "default:mossycobble"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 20,
    chance = 500,
    active_object_count = 3,
    min_height = -31000,
    max_height = -25,
    day_toggle = nil,
    on_spawn = nil,
  },
  copper = {
    nodes = {"default:stone_with_copper", "default:mossycobble", "default:blueberries"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 30,
    chance = 500,
    active_object_count = 2,
    min_height = -31000,
    max_height = -35,
    day_toggle = nil,
    on_spawn = nil,
  },
  iron = {
    nodes = {"default:stone_with_iron", "default:mossycobble"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 20,
    chance = 500,
    active_object_count = 3,
    min_height = -31000,
    max_height = -35,
    day_toggle = nil,
    on_spawn = nil,
  },
  gold = {
    nodes = {"default:stone_with_gold", "default:mossycobble"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 30,
    chance = 500,
    active_object_count = 2,
    min_height = -31000,
    max_height = -100,
    day_toggle = nil,
    on_spawn = nil,
  },
  diamond = {
    nodes = {"default:stone_with_diamond", "default:mossycobble"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 60,
    chance = 1000,
    active_object_count = 2,
    min_height = -31000,
    max_height = -200,
    day_toggle = nil,
    on_spawn = nil,
  },
  hoarder = {
    nodes = {"default:mossycobble","default:chest"},
    neighbors = "air",
    min_light = 0,
    max_light = 10,
    interval = 90,
    chance = 2000,
    active_object_count = 1,
    min_height = -31000,
    max_height = -20,
    day_toggle = nil,
    on_spawn = nil,
  },
  gobdog = {
    nodes = {"default:mossycobble", "group:sand"},
    min_light = 0,
    max_light = 14,
    chance = 500,
    active_object_count = 4,
    min_height = -31000,
    max_height = -20,
    day_toggle = nil,
    on_spawn = nil,
  },
  gobdog_aggro = {
    nodes = {"default:mossycobble", "group:sand"},
    min_light = 0,
    max_light = 6,
    chance = 500,
    active_object_count = 1,
    min_height = -31000,
    max_height = -100,
    day_toggle = nil,
    on_spawn = nil,
  }
}

---you can also override by declaring individual types here as follows:

goblins.spawning.gobdog = {
  nodes = {"default:mossycobble", "group:sand"},
  min_light = 0,
  max_light = 14,
  chance = 500,
  active_object_count = 4,
  min_height = -31000,
  max_height = -20,
  day_toggle = nil,
  on_spawn = nil,
}

-- alternatively you can make a custom file with something like:

-- dofile(path .. "/goblins_spawning_custom.lua")

-- and declare your overrides there.