-- Get the mod's name
local modname = core.get_current_modname()

-- Activate the translator component
local S = core.get_translator(modname)

-- Get the original item descriptions
local description_door_wood = core.registered_items["doors:door_wood"].description
local description_door_steel = core.registered_items["doors:door_steel"].description
local description_trapdoor = core.registered_items["doors:trapdoor"].description
local description_trapdoor_steel = core.registered_items["doors:trapdoor_steel"].description

-- Rename the original doors and trapdoors to "Door/trapdoor with a window"

core.override_item("doors:door_wood", {
	description = description_door_wood .. " " .. S("with a window"),
})

core.override_item("doors:door_steel", {
	description = description_door_wood .. " " .. S("with a window"),
})

core.override_item("doors:trapdoor", {
	description = description_trapdoor .. " " .. S("with a window"),
})

core.override_item("doors:trapdoor_steel", {
	description = description_trapdoor_steel .. " " .. S("with a window"),
})

-- Remove the old crafting recipes to register new ones

core.clear_craft({ output = "doors:door_wood" })
core.clear_craft({ output = "doors:door_steel" })
core.clear_craft({ output = "doors:trapdoor" })
core.clear_craft({ output = "doors:trapdoor_steel" })

-- Register the new doors and trapdoors using the doors API

doors.register("doors_without_window:door_wood", {
	tiles = { { name = modname .. "_door_wood.png", backface_culling = true } },
	description = description_door_wood,
	inventory_image = modname .. "_item_wood.png",
	groups = { choppy = 2, oddly_breakable_by_hand = 2, flammable = 2 },
	recipe = {
		{ "group:wood", "group:wood"},
		{ "group:wood", "group:wood"},
		{ "group:wood", "group:wood"},
	}
} )

doors.register("doors_without_window:door_steel", {
	tiles = { { name = modname .. "_door_steel.png", backface_culling = true } },
	description = description_door_steel,
	inventory_image = modname .. "_item_steel.png",
	groups = {node = 1, cracky = 1, level = 2},
	protected = true,
	sounds = default.node_sound_metal_defaults(),
			   sound_open = "doors_steel_door_open",
			   sound_close = "doors_steel_door_close",
			   gain_open = 0.2,
			   gain_close = 0.2,
			   recipe = {
				   { "default:steel_ingot", "default:steel_ingot"},
				   { "default:steel_ingot", "default:steel_ingot"},
				   { "default:steel_ingot", "default:steel_ingot"},
			   }
} )

doors.register_trapdoor("doors_without_window:trapdoor", {
	description = description_trapdoor,
	inventory_image = modname .. "_trapdoor.png",
	wield_image = modname .. "_trapdoor.png",
	tile_front = modname .. "_trapdoor.png",
	tile_side = "doors_trapdoor_side.png",
	gain_open = 0.06,
	gain_close = 0.13,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, door = 1},
})

doors.register_trapdoor("doors_without_window:trapdoor_steel", {
	description = description_trapdoor_steel,
	inventory_image = modname .. "_trapdoor_steel.png",
	wield_image = modname .. "_trapdoor_steel.png",
	tile_front = modname .. "_trapdoor_steel.png",
	tile_side = "doors_trapdoor_steel_side.png",
	protected = true,
	sounds = default.node_sound_metal_defaults(),
						sound_open = "doors_steel_door_open",
						sound_close = "doors_steel_door_close",
						gain_open = 0.2,
						gain_close = 0.2,
						groups = {cracky = 1, level = 2, door = 1},
})

-- Register crafting recipes for trapdoors, as the API doesn't have a built-in function for this

core.register_craft({
	type = "shaped",
	output = "doors_without_window:trapdoor 2",
	recipe = {
		{"group:wood", "group:wood", "group:wood"},
		{"group:wood", "group:wood", "group:wood"},
	}
})

core.register_craft({
	type = "shaped",
	output = "doors_without_window:trapdoor_steel",
	recipe = {
		{"default:steel_ingot", "default:steel_ingot"},
		{"default:steel_ingot", "default:steel_ingot"},
	}
})

-- Register more logical crafting recipes for the doors and trapdoors from the original 'doors' mod

core.register_craft({
	type = "shaped",
	output = "doors:door_wood",
	recipe = {
		{"group:wood", ""},
		{"group:wood", "group:wood"},
		{"group:wood", "group:wood"}
	}
})

core.register_craft({
	type = "shaped",
	output = "doors:door_steel",
	recipe = {
		{"default:steel_ingot", ""},
		{"default:steel_ingot", "default:steel_ingot"},
		{"default:steel_ingot", "default:steel_ingot"}
	}
})

core.register_craft({
	type = "shaped",
	output = "doors:trapdoor 2",
	recipe = {
		{"group:wood", "group:wood", ""},
		{"group:wood", "group:wood", "group:wood"},
	}
})

core.register_craft({
	type = "shaped",
	output = "doors:trapdoor_steel",
	recipe = {
		{"default:steel_ingot", ""},
		{"default:steel_ingot", "default:steel_ingot"},
	}
})