modname = "hypotalamussimulatormain"
S = core.get_translator(modname)

core.register_node(modname .. ":red", {
	tiles = {"hsm_noise.png^[fill:32x32:#ff103077"}
})
core.register_node(modname .. ":pink", {
	tiles = {"hsm_noise.png^[fill:32x32:#f5428177"}
})
core.register_node(modname .. ":beige", {
	tiles = {"hsm_noise.png^[fill:32x32:#dbca9177"}
})
core.register_node(modname .. ":orange", {
	tiles = {"hsm_noise.png^[fill:32x32:#f7981b88"}
})
core.register_node(modname .. ":brown", {
	tiles = {"hsm_noise.png^[fill:32x32:#634e3277"}
})
core.register_node(modname .. ":blue", {
	tiles = {"hsm_noise.png^[fill:32x32:#1bcbf777"}
})
core.register_node(modname .. ":white", {
	tiles = {"hsm_noise.png^[fill:32x32:#fffa"}
})

statuses = {"Chilling out", "Sleeping", "Eating salty", "Eating sugary", "Eating bad food", "Running", "Sick", "Playing", "Thinking"}
reloading = {
	adrenaline = 3,
	dopamine = 4,
	serotonin = 4,
	insulin = 8,
	glucagon = 8
}
autoregulation = {
	bpm = {
		goal = 80,
		loss = 0.1
	},
	blood_sugar = {
		goal = 0.8,
		loss = 0.01
	},
	blood_o2 = {
		goal = 100,
		loss = 0.2
	},
	blood_pressure = {
		goal = 78,
		loss = 0.2
	},
	fatigue = {
		awake = 0.15,
		asleep = 0.22
	},
	waste = {
		goal = 0,
		loss = 0.5/3
	},
	hunger = {
		eating = 3,
		asleep = 0.1,
		other = 0.2
	}
}
book_chapters = {
	{
		title = "Chilling out",
		description = "When Erwan isn't doing anything interesting, he is considered to be chilling out. At times like these, he needs less oxygen and glucose."
	}, {
		title = "Sleeping",
		description = "One of the most important daily tasks. Sleep serves many purposes: it repairs our tissues, aids digestion, checks that our organs and various parts of our brain are functioning properly, etc."
	}, {
		title = "Running",
		description = "One of Erwan's favorite physical activities is running. Sport serves to tire us out but also to maintain our muscles, including the heart and diaphragm."
	}, {
		title = "Eating salty",
		description = "Eating salty foods is simply what everyone does most of the time. So naturally, that's what Erwan does too!"
	}, {
		title = "Eating sugary",
		description = "Eating sweet foods is perfectly normal. That's the principle behind snacks and breakfast. Erwan loves it!"
	}, {
		title = "Eating bad food",
		description = "There are some things that Erwan doesn't like, just like everyone else. And when the menu isn't to his liking, it puts him in a bad mood…"
	}, {
		title = "Sick",
		description = "What could be more unpleasant than a headache or stomachache? It happens, and it's not always so bad for our bodies."
	}, {
		title = "Playing",
		description = "Whether it's board games or video games, playing helps reduce stress and often satisfies our social needs. Playing is sometimes even used as a medical treatment!"
	}, {
		title = "Thinking",
		description = "Many people have manual and physical jobs. Others have more knowledge- and thought-based jobs... Erwan belongs to this second group."
	}, {
		title = " BPM",
		description = "Beats per minute (BPM) is the number of times the heart pumps blood to the body. Ideally, BPM should remain between 70 and 100."
	}, {
		title = "Blood O2",
		description = "The primary function of blood is to transport various molecules for the proper functioning of our organs. One of the most important molecules is oxygen."
	}, {
		title = "Blood Sugar",
		description = "Our muscles need sugar to produce energy. The amount of sugar in the blood is called blood sugar."
	}, {
		title = "Mental",
		description = "The importance of mental health is often underestimated when we talk about health. But being unhappy has direct physical effects!"
	}, {
		title = "Fatigue",
		description = "Erwan's days are often exhausting! Fortunately, he is used to sleeping at least 5 hours per night... But that's still not enough..."
	}, {
		title = "Consciousness",
		description = "Consciousness is the ability to respond to external signals. It is measured using the Glasgow Coma Scale, which ranges from 15 (fully conscious) to 3 (deep coma)."
	}, {
		title = "Blood Pressure",
		description = "Blood pressure is measured in millimetres of mercury. For simplicity's sake, only diastolic blood pressure is shown here."
	}, {
		title = "Waste",
		description = "Every action produces different types of waste in our bodies. These are slowly absorbed and then excreted. The best known of these is lactic acid."
	}, {
		title = "Adrenaline",
		description = "Adrenaline is a hormone that optimises the body during exercise. It accelerates the heartbeat and improves the oxygen supply to the blood."
	}, {
		title = "Dopamine",
		description = "Dopamine is a happiness hormone. It is normally released during activities that give the body pleasure. But beware of addiction!"
	}, {
		title = "Serotonin",
		description = "Serotonin is a monoamine that calms the body in order to protect it. It slows down the heartbeat and promotes tiredness."
	}, {
		title = "Insulin",
		description = "Insulin is a hormone that regulates blood sugar. It is the opposite of glucagon: it tells the cells to absorb sugar from the blood in order to lower its concentration."
	}, {
		title = "Glucagon",
		description = "Glucagon is a hormone that regulates blood sugar. It is the opposite of insulin: it tells the pancreas to produce sugar in order to increase its concentration in the blood."
	}
}

musictime = -3
musichandle = nil

function simple_float(float)
	return math.round(float*10)/10
end

function sf(float)
	return simple_float(float)
end

function hypertext_styler(options)
	return "<style color=#" .. (options.color == nil and "000" or options.color) .. " size=" .. (options.size == nil and "20" or options.size) .. ">" .. (options.center == false and "" or "<center>") .. options.text .. (options.center == false and "" or "</center>") .. "</style>"
end

function hps(options)
	return hypertext_styler(options)
end

function showform(pl)
	local info = core.get_player_window_information(pl:get_player_name())
	local meta = pl:get_meta()
	local adrenaline = meta:get_float("adrenaline")
	local dopamine = meta:get_float("dopamine")
	local serotonin = meta:get_float("serotonin")
	local insulin = meta:get_float("insulin")
	local glucagon = meta:get_float("glucagon")
	local book_state = meta:get_int("book_state")
	local sx = info.max_formspec_size.x
	local sy = info.max_formspec_size.y
	local ub = { -- up bar
		h = sy*0.05,
		w = sx*0.5,
		x = sx*0.25
	}
	ub.ipx = ub.w/20 -- item padding x
	ub.ipy = ub.h/10
	ub.iw = ub.w/4
	ub.ih = ub.h-ub.ipy
	ub.iis = math.min(ub.ih, ub.iw/5) -- item icon size
	ub.itw = ub.iw-(2*ub.iis) -- item text width
	local lb = { -- left bar
		h = sy*0.3,
		w = sx*0.1,
		y = sy*0.35
	}
	lb.ipx = lb.w/20
	lb.ipy = lb.h/10
	local bk = {} -- book
	bk.h = sy*0.5
	bk.w = sx*0.5
	bk.y = sy*0.25
	bk.x = sx*0.25
	bk.ipx = bk.w/10
	bk.th = bk.h/12 -- title height
	bk.dy = bk.th*2 -- description y
	bk.dh = bk.h-bk.dy*3
	local rb = { -- right bar
		h = sy*0.6,
		w = sx*0.2,
		y = sy*0.2
	}
	rb.x = sx-rb.w
	rb.ipx = rb.w/20
	rb.ipy = rb.h/20
	rb.ih = rb.h/10-rb.ipy
	local tb = { -- time bar
		s = math.min(ub.x, rb.y)/2 -- h & w
	}
	tb.x = sx-tb.s*1.1
	tb.y = tb.s*.1
	core.show_formspec(pl:get_player_name(), "hsm_form", 
		"formspec_version[9]" ..
		"size[" .. sx .. "," .. sy .. "]" ..
		"padding[0,0]" ..
		"style_type[image_button;bgcolor=#900f;border=false]" ..
		"bgcolor[;neither;]" ..
		"scrollbaroptions[thumbsize=0]" ..
		( -- Up bar
			"container[" .. ub.x .. ",0]" ..
			"box[0,0;" .. ub.w .. "," .. ub.h .. ";#ccfa]" ..
			"image["     .. ub.ipx                .. "," .. ub.ipy .. ";" .. ub.iis  .. "," .. ub.iis .. ";hsm_bpm.png]" ..
			"hypertext[" .. ub.iis+ub.ipx       .. "," .. ub.ipy .. ";" .. ub.itw  .. "," .. ub.ih  .. ";;" .. hps{center=false, text=(sf(meta:get("bpm"))           .. S(" BPM"))} .. "]" ..
			"image["     .. ub.iw+ub.ipx          .. "," .. ub.ipy .. ";" .. ub.iis  .. "," .. ub.iis .. ";hsm_blood_o2.png]" ..
			"hypertext[" .. ub.iis+ub.iw+ub.ipx   .. "," .. ub.ipy .. ";" .. ub.itw  .. "," .. ub.ih  .. ";;" .. hps{center=false, text=(sf(meta:get("blood_o2"))    .. " %")}      .. "]" ..
			"image["     .. 2*ub.iw+ub.ipx        .. "," .. ub.ipy .. ";" .. ub.iis  .. "," .. ub.iis .. ";hsm_blood_sugar.png]" ..
			"hypertext[" .. ub.iis+2*ub.iw+ub.ipx .. "," .. ub.ipy .. ";" .. ub.itw  .. "," .. ub.ih  .. ";;" .. hps{center=false, text=(sf(meta:get("blood_sugar")) .. S(" g/L"))} .. "]" ..
			"image["     .. 3*ub.iw+ub.ipx        .. "," .. ub.ipy .. ";" .. ub.iis  .. "," .. ub.iis .. ";hsm_waste.png]"..
			"hypertext[" .. ub.iis+3*ub.iw+ub.ipx .. "," .. ub.ipy .. ";" .. ub.itw  .. "," .. ub.ih  .. ";;" .. hps{center=false, text=(sf(meta:get("waste"))       .. " /10")}    .. "]" ..
			"container_end[]"
		) .. ( -- left bar
			"container[0," .. lb.y .. "]" ..
			"box[0,0;" .. lb.w .. "," .. lb.h .. ";#ccfa]" ..
			"hypertext[" .. lb.ipx .. "," .. lb.ipy .. ";" .. lb.w-lb.ipx*2 .. "," .. lb.h/2-lb.ipy  .. ";;" .. hps{size=25, text=S("Erwan is…")} .."]" ..
			"hypertext[" .. lb.ipx .. "," .. lb.h/2 .. ";" .. lb.w-lb.ipx*2 .. "," .. lb.h/2-lb.ipy  .. ";;" .. hps{color="b00", size=25, text=S(statuses[meta:get_int("status")])} .."]" ..
			"image_button[" .. (lb.w-lb.w/4)/2 .. "," .. lb.h-lb.ipy*3 .. ";" .. lb.w/4 .. "," .. lb.w/4 .. ";hsm_book.png;switch_book;]" ..
			"container_end[]"
		) .. (-- book
			book_state == 0 and "" or (
				"container[" .. bk.x .. "," .. bk.y .. "]" ..
				"box[0,0;" .. bk.w .. "," .. bk.h .. ";#cfca]" ..
				"hypertext[" .. bk.ipx .. "," .. bk.th .. ";" .. bk.w-bk.ipx*2 .. "," .. bk.th  .. ";;" .. hps{size=25, text=S(book_chapters[book_state]["title"])} .."]" ..
				"hypertext[" .. bk.ipx .. "," .. bk.dy .. ";" .. bk.w-bk.ipx*2 .. "," .. bk.dh  .. ";;" .. hps{text=S(book_chapters[book_state]["description"])} .."]" ..
				(book_state <= 1              and "" or "image_button[" .. bk.ipx                 .. "," .. bk.h-bk.th .. ";" .. (bk.w-bk.ipx*2)/2 .. "," .. bk.th  .. ";hsm_arrow.png;book_previus;"           .. S(book_chapters[book_state-1]["title"]) .. "]" )..
				(book_state >= #book_chapters and "" or "image_button[" .. bk.ipx+(bk.w-bk.ipx)/2 .. "," .. bk.h-bk.th .. ";" .. (bk.w-bk.ipx*2)/2 .. "," .. bk.th  .. ";hsm_arrow.png^[transformFX;book_next;" .. S(book_chapters[book_state+1]["title"]) .. "]" ) ..
				"container_end[]"
			)
		) .. (-- right bar
			"container[" .. rb.x .. "," .. rb.y .. "]" ..
			"box[0,0;" .. rb.w .. "," .. rb.h .. ";#ccfa]" ..
			"hypertext[" .. rb.ipx .. "," ..  lb.ipy          .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. ";;" .. hps{text=S("Adrenaline")} .. "]" ..
			(adrenaline > 0 and "image" or "image_button") .. "[" .. rb.ipx .. "," ..  lb.ipy+rb.ih            .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. (adrenaline > 0 and (";hsm_bar_" .. 10*math.floor(10*adrenaline/3) .. ".png") or (";hsm_bar_0.png;add_adrenaline;"  .. S("Produce"))) .. "]" ..
			"hypertext[" .. rb.ipx .. "," .. (lb.ipy+rb.ih)*2 .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. ";;" .. hps{text=S("Dopamine")} .. "]" ..
			(dopamine > 0 and "image" or "image_button")   .. "[" .. rb.ipx .. "," .. lb.ipy+(lb.ipy+rb.ih)*2  .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. (dopamine > 0 and (";hsm_bar_" .. 10*math.floor(10*dopamine/3) .. ".png") or (";hsm_bar_0.png;add_dopamine;"  .. S("Produce"))) .. "]" ..
			"hypertext[" .. rb.ipx .. "," .. (lb.ipy+rb.ih)*4 .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. ";;" .. hps{text=S("Serotonin")} .. "]" ..
			(serotonin > 0 and "image" or "image_button")  .. "[" .. rb.ipx .. "," .. lb.ipy+(lb.ipy+rb.ih)*4  .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. (serotonin > 0 and (";hsm_bar_" .. 10*math.floor(10*serotonin/3) .. ".png") or (";hsm_bar_0.png;add_serotonin;"  .. S("Produce"))) .. "]" ..
			"hypertext[" .. rb.ipx .. "," .. (lb.ipy+rb.ih)*6 .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. ";;" .. hps{text=S("Insulin")} .. "]" ..
			(insulin > 0 and "image" or "image_button")    .. "[" .. rb.ipx .. "," .. lb.ipy+(lb.ipy+rb.ih)*6  .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. (insulin > 0 and (";hsm_bar_" .. 10*math.floor(10*insulin/3) .. ".png") or (";hsm_bar_0.png;add_insulin;"  .. S("Produce"))) .. "]" ..
			"hypertext[" .. rb.ipx .. "," .. (lb.ipy+rb.ih)*8 .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. ";;" .. hps{text=S("Glucagon")} .. "]" ..
			(glucagon > 0 and "image" or "image_button")   .. "[" .. rb.ipx .. "," .. lb.ipy+(lb.ipy+rb.ih)*8  .. ";" .. rb.w-rb.ipx*2 .. "," .. rb.ih .. (glucagon > 0 and (";hsm_bar_" .. 10*math.floor(10*glucagon/3) .. ".png") or (";hsm_bar_0.png;add_glucagon;"  .. S("Produce"))) .. "]" ..
			"container_end[]"
		) .. ( -- other things
			"button_exit[0,0;" .. sx*0.05 .. "," .. sy*0.05 .. ";exit_btn;Quit]" ..
			"image[" .. tb.x .. "," .. tb.y .. ";" .. tb.s .. "," .. tb.s .. ";hsm_time_bg.png]" ..
			"model[" .. tb.x .. "," .. tb.y .. ";" .. tb.s .. "," .. tb.s .. ";;hsm_plane.obj;hsm_time_hand.png;180," .. -360*(meta:get_float("hour")/24) .. "]"
		)
	)
end

function showform_loop(pl)
	showform(pl)
	core.after(0.4, showform_loop, pl)
end

core.register_globalstep(function(dtime)
	for _, pl in ipairs(core.get_connected_players()) do
		pl:set_look_vertical(2.5*math.pi)
		pl:set_look_horizontal(0)
		local pos = pl:get_pos()
		pl:move_to({x=20, y=20, z=(pos.z-1/(10000*dtime))})
		if (pos.z <= 33 or pos.z > 100) then
			pl:set_pos({x=20, y=20, z=60})
		end
		local meta = pl:get_meta()
		if (meta) then
			local bpm = meta:get_float("bpm")
			local blood_sugar = meta:get_float("blood_sugar")
			local blood_o2 = meta:get_float("blood_o2")
			local blood_pressure = meta:get_float("blood_pressure")
			local mental = meta:get_float("mental")
			local fatigue = meta:get_float("fatigue")
			local consciousness = meta:get_float("consciousness")
			local waste = meta:get_float("waste")
			do
				local hour = meta:get_float("hour")
				hour = hour + dtime/3
				hour = hour%24
				meta:set_float("hour", hour)
				local status = meta:get_int("status")
				local status_before = status
				local last_status_change = meta:get_float("last_status_change")
				local hunger = meta:get_float("hunger")
				if (hour > 23 or hour < 4) then
					status = 2 -- sleeping
				elseif (hour-last_status_change > 2 or hour-last_status_change < 0) then
					if (fatigue >= 10) then
						status = 2 -- sleeping
					elseif (status ~= 2 or fatigue <= 0) then
						if (hunger > 9) then
							status = 4 + math.floor(math.random()*3) -- eating
						else
							status = 6 + math.floor(math.random()*(#statuses - 5)) -- other
						end
					end
				end
				if (status ~= status_before) then
					last_status_change = hour
					if (status == 0) then
						mental = mental + 1
						fatigue = fatigue - 1
					elseif (status == 1) then
						fatigue = fatigue - 10
						consciousness = consciousness - 2
						blood_pressure = blood_pressure - 1
						waste = waste - 2
					elseif (status == 3) then
						blood_o2 = blood_o2 - 12
						blood_sugar = blood_sugar - 0.13
						fatigue = fatigue + 3
						waste = waste + 5
					elseif (status == 4) then
						mental = mental + 1
						blood_pressure = blood_pressure + 2
						waste = waste + 2
					elseif (status == 5) then
						blood_sugar = blood_sugar + 0.14
						mental = mental + 1
						blood_pressure = blood_pressure + 3
						waste = waste + 2
					elseif (status == 6) then
						blood_sugar = blood_sugar + 0.03
						mental = mental - 3
						blood_pressure = blood_pressure + 2
						waste = waste + 2
					elseif (status == 7) then
						fatigue = fatigue + 6
						consciousness = consciousness - 1
						waste = waste + 1
					elseif (status == 8) then
						blood_sugar = blood_sugar - 0.07
						mental = mental + 4
					else
						bpm = bpm - 2
						fatigue = fatigue + 2
					end
				end
				fatigue = fatigue + ((status == 2) and -1*autoregulation.fatigue.asleep or autoregulation.fatigue.awake)*dtime
				hunger = hunger + ((status >= 4 and status <= 6) and -1*autoregulation.hunger.eating or ((status == 2) and autoregulation.hunger.asleep or autoregulation.hunger.other))*dtime
				meta:set_int("status", status)
				meta:set_float("last_status_change", last_status_change)
				meta:set_float("hunger", hunger)
			end
			do
				local adrenaline = meta:get_float("adrenaline")
				local dopamine = meta:get_float("dopamine")
				local serotonin = meta:get_float("serotonin")
				local insulin = meta:get_float("insulin")
				local glucagon = meta:get_float("glucagon")
				if (adrenaline > 0) then
					adrenaline = adrenaline + dtime/(reloading.adrenaline/2)
					if (adrenaline > 3) then
						adrenaline = 0
					elseif (adrenaline > 2) then
						bpm = bpm + dtime*21/(reloading.adrenaline/2)
						blood_o2 = blood_o2 + dtime*10/(reloading.adrenaline/2)
						blood_sugar = blood_sugar + dtime*0.05/(reloading.adrenaline/2)
						waste = waste + dtime*4/(reloading.adrenaline/2)
						mental = mental - dtime/(reloading.adrenaline/2)
						fatigue = fatigue + dtime*2/(reloading.adrenaline/2)
					end
				end
				if (dopamine > 0) then
					dopamine = dopamine + dtime/(reloading.dopamine/2)
					if (dopamine > 3) then
						dopamine = 0
					elseif (dopamine > 2) then
						bpm = bpm + dtime*5/(reloading.dopamine/2)
						waste = waste + dtime*2/(reloading.dopamine/2)
						mental = mental + dtime*6/(reloading.dopamine/2)
						fatigue = fatigue + dtime*2/(reloading.dopamine/2)
					end
				end
				if (serotonin > 0) then
					serotonin = serotonin + dtime/(reloading.serotonin/2)
					if (serotonin > 3) then
						serotonin = 0
					elseif (serotonin > 2) then
						bpm = bpm - dtime*2/(reloading.serotonin/2)
						waste = waste + dtime/(reloading.serotonin/2)
						mental = mental + dtime*3/(reloading.serotonin/2)
						fatigue = fatigue + dtime*4/(reloading.serotonin/2)
					end
				end
				if (insulin > 0) then
					insulin = insulin + dtime/8
					if (insulin > 3) then
						insulin = 0
					elseif (insulin > 2) then
						blood_sugar = blood_sugar - dtime*0.15/(reloading.insulin/2)
						mental = mental - dtime/(reloading.insulin/2)
						fatigue = fatigue + dtime/(reloading.insulin/2)
					end
				end
				if (glucagon > 0) then
					glucagon = glucagon + dtime/8
					if (glucagon > 3) then
						glucagon = 0
					elseif (glucagon > 2) then
						bpm = bpm + dtime*0/(reloading.glucagon/2)
						blood_o2 = blood_o2 + dtime*0/(reloading.glucagon/2)
						blood_sugar = blood_sugar + dtime*0.15/(reloading.glucagon/2)
						waste = waste + dtime*0/(reloading.glucagon/2)
						mental = mental + dtime*(-1)/(reloading.glucagon/2)
						fatigue = fatigue + dtime*1/(reloading.glucagon/2)
					end
				end
				do
					local loss = autoregulation.bpm.loss
					local diff = autoregulation.bpm.goal - bpm
					local add = (((diff < loss) and (diff > -1*loss)) and diff or (diff<0 and -1*loss or (diff>0 and loss or 0)))
					bpm = bpm + add * dtime
				end
				do
					local loss = autoregulation.blood_sugar.loss
					local diff = autoregulation.blood_sugar.goal - blood_sugar
					local add = (((diff < loss) and (diff > -1*loss)) and diff or (diff<0 and -1*loss or (diff>0 and loss or 0)))
					blood_sugar = blood_sugar + add * dtime
				end
				do
					local loss = autoregulation.blood_o2.loss
					local diff = autoregulation.blood_o2.goal - blood_o2
					local add = (((diff < loss) and (diff > -1*loss)) and diff or (diff<0 and -1*loss or (diff>0 and loss or 0)))
					blood_o2 = blood_o2 + add * dtime
				end
				do
					local loss = autoregulation.blood_pressure.loss
					local diff = autoregulation.blood_pressure.goal - blood_pressure
					local add = (((diff < loss) and (diff > -1*loss)) and diff or (diff<0 and -1*loss or (diff>0 and loss or 0)))
					blood_pressure = blood_pressure + add * dtime
				end
				do
					local loss = autoregulation.waste.loss
					local diff = autoregulation.waste.goal - waste
					local add = (((diff < loss) and (diff > -1*loss)) and diff or (diff<0 and -1*loss or (diff>0 and loss or 0)))
					waste = waste + add * dtime
				end
				meta:set_float("adrenaline", adrenaline)
				meta:set_float("dopamine", dopamine)
				meta:set_float("serotonin", serotonin)
				meta:set_float("insulin", insulin)
				meta:set_float("glucagon", glucagon)
			end
			do
				local death_message = ""
				if (bpm < 60 or bpm > 170) then
					death_message = "Heart attack"
				elseif (blood_sugar < 0.6) then
					death_message = "Hypoglycemia"
				elseif (blood_sugar > 1.1) then
					death_message = "Diabetes"
				elseif (blood_o2 < 60) then
					death_message = "Hypoxia"
				elseif (blood_pressure < 50) then
					death_message = "Hypotension"
				elseif (blood_pressure > 180) then
					death_message = "Hypertension"
				elseif (mental < 4) then
					death_message = "Depresion that leeds to sucide"
				elseif (consciousness < 4) then
					death_message = "Coma"
				elseif (waste > 10) then
					death_message = "Tetany"
				end
				if (death_message ~= "") then
					core.disconnect_player(pl:get_player_name() , S("Erwan died because of ") .. S(death_message))
					core.ban_player(pl:get_player_name())
				end
			end
			do
			end
			meta:set_float("bpm", bpm)
			meta:set_float("blood_sugar", blood_sugar)
			meta:set_float("blood_o2", (blood_o2 <= 100 and blood_o2 or 100))
			meta:set_float("blood_pressure", blood_pressure)
			meta:set_float("mental", mental)
			meta:set_float("fatigue", fatigue)
			meta:set_float("consciousness", consciousness)
			meta:set_float("waste", waste)
		end
	end
	if (musictime > 0 and musictime < 2*dtime) then
		if (musichandle) then
			core.sound_stop(musichandle)
		end
		musichandle = core.sound_play("melodyvollen.ogg", {})
		core.log("soudplay")
	end
	musictime = (musictime + dtime)%180
end)

core.register_on_player_receive_fields(function(player, formname, fields)
	if (formname == "hsm_start") then
		if (core.place_schematic({x=0, y=1, z=0}, core.get_modpath(modname) .. "/schems/body.mts", "0", {}, true) == nil) then
			core.disconnect_player(player:get_player_name(), "Schematic placement error")
		end
		showform_loop(player)
	elseif (formname == "hsm_form") then
		local meta = player:get_meta()
		local book_state = meta:get_int("book_state")
		if fields["exit_btn"] == "Quit" then
			core.disconnect_player(player:get_player_name(), "You exited this body...")
		elseif fields["add_adrenaline"] ~= nil then
			meta:set_float("adrenaline", 0.1)
		elseif fields["add_dopamine"] ~= nil then
			meta:set_float("dopamine", 0.1)
		elseif fields["add_serotonin"] ~= nil then
			meta:set_float("serotonin", 0.1)
		elseif fields["add_insulin"] ~= nil then
			meta:set_float("insulin", 0.1)
		elseif fields["add_glucagon"] ~= nil then
			meta:set_float("glucagon", 0.1)
		elseif fields["book_previus"] ~= nil then
			meta:set_int("book_state", book_state-1)
		elseif fields["book_next"] ~= nil then
			meta:set_int("book_state", book_state+1)
		elseif fields["switch_book"] == "" then
			if (meta:get_int("book_state") == 0) then
				meta:set_int("book_state", 1)
			else
				meta:set_int("book_state", 0)
			end
		end
		showform(player)
	end
end)

core.register_on_newplayer(function(player)
	local meta = player:get_meta()
	meta:from_table({
		fields = {
			adrenaline = 0,
			dopamine = 0,
			serotonin = 0,
			insulin = 0,
			glucagon = 0,
			bpm = 80,
			blood_sugar = 0.8,
			blood_o2 = 95,
			mental = 10,
			fatigue = 3,
			consciousness = 15,
			blood_pressure = 78,
			waste = 2,
			hunger = 0,
			respiration_speed = 0,
			status = 1,
			last_status_change = 0,
			addiction = 0, -- TODO: 
			hour = 1, -- 3 sec = 1 hour
			book_state = 0
		}
	})
end)

core.register_on_joinplayer(function(player)
	--[[for i, v in pairs(core.get_player_window_information(player:get_player_name())) do
		core.log(i .. " : " .. v)
	end]]--
	local form_cmd = "" --core.get_player_window_information(player:get_player_name())["touch_controls"] and "" or "Enter, Escape or "
	core.show_formspec(player:get_player_name(), "hsm_start", "formspec_version[9]size[64,36]bgcolor[#333;both;#333]label[10,10;44,6;" .. S("Wellcome to Hypotalamus Simulator!\nIn this game, you need to control the reaction of the body of Erwan to external actions.\nGood luck!\n\nPress " .. form_cmd .. "the button bellow to start the game.") ..  "]button_exit[10,21;44,5;;" .. S("Play!") .. "]")
	core.hud_replace_builtin("breath", {})
	core.hud_replace_builtin("health", {})
	core.hud_replace_builtin("minimap", {})
	core.hud_replace_builtin("hotbar", {})
	player:set_camera({"first"})
	player:set_pos({x=20, y=20, z=60})
	player:set_formspec_prepend("")
	player:hud_set_flags({
		hotbar = false,
		healthbar = false,
		crosshair = false,
		wielditem = false,
		breathbar = false,
		minimap = false,
		minimap_radar = false,
		basic_debug = false,
		chat = false
	})
end)