# OldBlock Edition

**OldBlock Edition** is a faithful recreation of **Minecraft Pocket Edition 0.1.x** built on the [Luanti/Minetest](https://www.luanti.org) engine.  
The project’s goal is to replicate the look, feel, and gameplay of the very first public MCPE versions (0.1.0–0.1.2), while remaining open-source and moddable.

---

## ✨ Features

- Finite 256×256 worlds, height 64 (like MCPE 0.1.x)  
- Rolling plains with oak trees, sand patches, and puddles  
- Simplified creative-only gameplay  
- Instant block breaking (no drops)  
- Three-slot hotbar (preloaded with blocks)  
- No survival elements (no hearts, hunger, or damage)  
- Nostalgic pixel textures (Pixel Perfection & custom work)  
- World border enforced to stay true to early MCPE limits  

---

## 📦 Included Blocks & Items (0.1.x set)

- Stone, cobblestone, dirt, sand, gravel  
- Grass block (colorized overlay)  
- Oak logs, planks, leaves, saplings  
- Wool (16 colors)  
- Glass, bookshelf  
- Bedrock, TNT (placeholder, non-functional)  
- Water, lava (creative placement only)  
- Torch 
- Cyan flower (mapgen decoration)

---

## 📂 Installation

1. Install [Luanti/Minetest 5.13+](https://www.luanti.org/downloads/).  
2. Clone or download this repository into your `games/` directory:  
   ```bash
   git clone https://github.com/Gerold55/oldblock_edition.git
   ```  
   You should now have:  
   ```
   games/oldblock_edition/
   ```
3. Launch Luanti/Minetest, select **OldBlock Edition** from the Games list, and create a new world.  
4. Ensure the mapgen is set to **singlenode** (automatically enforced).  

---

## 🎨 Screenshots

*(Add screenshots here once ready — showing inventory, worldgen, and nostalgic menu.)*

---

## ⚖️ Licensing

This project combines several licenses. Please read [`LICENSE.txt`](LICENSE.txt) for full details.

- **OldBlock Edition code** → MIT (© 2025 Gerold55)  
- **player_api code** → LGPL-2.1  
- **player_api media** → CC BY-SA 3.0 / CC BY 3.0  
- **Pixel Perfection textures** → CC BY-SA 4.0  
- **Additional hotbar textures** → by LuantiVideos (credited separately)  

---

## 🙏 Credits

- **Gerold55** — project creator and maintainer  
- **Luanti/Minetest Developers** — engine & player API  
- **Pixel Perfection authors** — base texture pack  
- **LuantiVideos** — hotbar textures  
- **Community contributors** — testing, bugfixes, and nostalgia!  

---

## 🚀 Roadmap

- [ ] Update to 0.2.X  
- [ ] Future-proof grass/leaf coloring for later biome updates

---

## ❤️ Contributing

Pull requests, bug reports, and feedback are welcome!  
Please open an issue or PR on [GitHub Issues](../../issues).  

---

## 📜 Disclaimer

This project is **not affiliated with Mojang, Microsoft, or Minecraft**.  
All names, brands, and related assets are the property of their respective owners.  
OldBlock Edition is a fan-made recreation built on the Luanti/Minetest engine.
