--SOUL STONE WORLD CODE BORROWED FROM TARDIS_NEW--
data = minetest.get_mod_storage()

local soul_on_place = function(pos, placer, itemstack, pointed_thing)
	if placer:get_player_name() == "" then return else
		local meta = minetest.get_meta(pos)
		local name = placer:get_player_name()
		local timer = minetest.get_node_timer(pos)
		if data:get_string(name.."in_pos") == "" then
			data:set_string(name.."out_pos", minetest.serialize(pos)) --set exterior position
			pos.y = pos.y-300
			minetest.place_schematic(pos, minetest.get_modpath("infinity") .. "/schemes/soulworld2.mts")
			pos.y = pos.y+2
			pos.x = pos.x+7
			pos.z = pos.z+15
			local ometa = minetest.get_meta(pos)
			local otimer = minetest.get_node_timer(pos)
			otimer:start(0.2) --start door timer (in case it doesn't start on construct)
			ometa:set_string("id", name) --set door id
			meta:set_string("id", name) -- set exterior id
			data:set_string(name.."in_pos", minetest.serialize(pos)) --set interior position
			data:set_int(name.."power", 0) --set power
			data:set_int(name.."factor", 1) -- set travel factor
			data:set_string(name.."look", "infinity:soulworld") --set skin
			data:set_int(name.."y_dest", 0)
			data:set_int(name.."x_dest", 0)
			data:set_int(name.."z_dest", 0)
			data:set_string(name.."way1", minetest.serialize({x=0, y=0, z=0}) )
			data:set_string(name.."way2", minetest.serialize({x=0, y=0, z=0}) )
			data:set_string(name.."way3",minetest.serialize({x=0, y=0, z=0}) )
			data:set_string(name.."r_pos", "") 
			timer:start(0.2)
		else minetest.set_node(pos, {name = "air"}) minetest.add_item(pos, "infinity:soulworld") end
	end
end
local infinity_timer = function(pos)
	local objs = minetest.get_objects_inside_radius(pos, 0.9)
	if objs[1] == nil then return true else
		if objs[1]:is_player() then
			local meta = minetest.get_meta(pos)
			local pmeta = objs[1]:get_meta()
			local id = meta:get_string("id")
			local go_pos = minetest.deserialize(data:get_string(id.."in_pos"))
			go_pos.z = go_pos.z-1
			objs[1]:set_look_horizontal( math.rad( 180 ))
			objs[1]:set_look_vertical( math.rad( 0 ))
			objs[1]:set_pos(go_pos)
			pmeta:set_string("id", id)
		else
			local meta = minetest.get_meta(pos)
			local id = meta:get_string("id")
			local go_pos = minetest.deserialize(data:get_string(id.."in_pos"))
			go_pos.z = go_pos.z-2
			objs[1]:set_pos(go_pos)
		end
	end
	return true
end
--------------------
--NODE DEFINITIONS--
--------------------

minetest.register_node("infinity:soulworld", {
		description = "Entrance to the Soul World...",
		tiles = {"infinity_soul_portal.png"},
		drawtype = "mesh",
		mesh = "tardis_2.obj",
		selection_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
		collision_box = {type = "fixed", fixed = { { 0.48, -0.5,-0.5,  0.5,  1.5, 0.5}, {-0.5 , -0.5, 0.48, 0.48, 1.5, 0.5}, {-0.5,  -0.5,-0.5 ,-0.48, 1.5, 0.5}, { -0.8,-0.6,-0.8,0.8,-0.48, 0.8} }},
		light_source = 100,
		paramtype2 = "facedir",
		groups = {unbreakable = 1},
		diggable = false,
		after_place_node = soul_on_place,
		on_timer = infinity_timer
})
if minetest.get_modpath("1myfavs") then
minetest.register_node("infinity:zfakesoulworld", {
		description = "FAKE..soulworld",
		tiles = {"infinity_soul_portal.png"},
		drawtype = "mesh",
		mesh = "tardis_2.obj",
		selection_box = {type = "fixed", fixed = { { -0.5, -0.5, -0.5, 0.5, 1.5, 0.5 } }},
		collision_box = {type = "fixed", fixed = { { 0.48, -0.5,-0.5,  0.5,  1.5, 0.5}, {-0.5 , -0.5, 0.48, 0.48, 1.5, 0.5}, {-0.5,  -0.5,-0.5 ,-0.48, 1.5, 0.5}, { -0.8,-0.6,-0.8,0.8,-0.48, 0.8} }},
		light_source = 100,
		paramtype2 = "facedir",
		groups = {unbreakable = 1},
})
end
minetest.register_chatcommand("summonsoul", {
	params = "",
	description = "Summons Your Soul Entrance to Your Location",
	privs = {},
	func = function(name)
    if data:get_string(name.."in_pos") == "" then return false, "soul world not found" else
		local player = minetest.get_player_by_name(name)
		local select_pos = player:get_pos()
		local out_pos = minetest.deserialize(data:get_string(name.."out_pos"))
		local look = data:get_string(name.."look")
		minetest.set_node(out_pos, {name = "air"})
		out_pos.x = math.ceil(select_pos.x)
		out_pos.y = math.ceil(select_pos.y)
		out_pos.z = math.ceil(select_pos.z)	
		minetest.set_node(out_pos, {name=look})
		local ometa = minetest.get_meta(out_pos)
		ometa:set_string("id", name)
		data:set_string(name.."out_pos", minetest.serialize(out_pos))
		local timer = minetest.get_node_timer(out_pos)
		timer:start(0.5)
		minetest.chat_send_player(name, "Soul World Summoned")
	end
	end
})