
minetest.register_alias("mapgen_stone", "re_stone:stone")
minetest.register_alias("mapgen_water_source", "air")

-- these tell core what nodes to generate in the world


re_mapgen = {}

local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)

core.register_biome({
    name = this_biome,

    node_top = "re_soil:grass",
    depth_top = 1,

    node_filler = "re_soil:dirt",
    depth_filler = 5,


    y_max = alt_max,
    y_min = sealevel,
    vertical_blend = 2,

    heat_point = 50,
    humidity_point = 50,
})

function re_mapgen.get_schematic_path(name)
    return (mod_path .. "/schematics/" .. name .. ".mts")
end


core.register_on_newplayer(function(player)
	core.place_schematic(
		{ x = 0, y = 4, z = 0 },
		re_mapgen.get_schematic_path("prison"),
		nil,
		nil,
		true,
		nil
	)
	player:set_pos({ x = 3, y = 10, z = 6 })
end)

