
core.register_node("robot_escape:prisonwall", {
    description = "A reminder of your situation",
    tiles = {"prisonwall.png"},
	groups = {cracky = 1},
	paramtype = "light",
	light_source = 1,
})
core.register_node("robot_escape:metalwall", {
    description = "Unbreakable",
    tiles = {"metalwall.png"},
	paramtype = "light",
	light_source = 1,
})
core.register_node("robot_escape:deeprock", {
    description = "Unbreakable",
    tiles = {"deepstone.png"},
	paramtype = "light",
	light_source = 1,
})

core.register_node("robot_escape:grille", {
    description = "A reminder of your freedom",
	drawtype = "nodebox",
    tiles = {
        "empty.png",
        "empty.png",
        "grille.png",
		"grille.png",
        "empty.png",
		"empty.png",
    },
	node_box = {
        type = "fixed",
        fixed = {
            {0, -0.5, -0.5, 0, 0.5, 0.5},
        },
    },
	groups = {snappy = 1},
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = "4dir",
	light_source = 1,
})

core.register_node("robot_escape:leaves", {
    description = "Leaves, not much to say about it",
	drawtype ="robot_escape",
    tiles = {"leavestext.png"},
	groups = {snappy = 1},
	use_texture_alpha = "clip",
	paramtype = "light",
	light_source = 1,
})

core.register_node("robot_escape:drillget", {
    description = "Gives you a drill",
	drawtype ="glasslike",
    tiles = {"drillget.png"},
	walkable = false,
	use_texture_alpha = "blend",
	post_effect_color = "#fffb1764",
    --groups = {cracky = 1},
	paramtype = "light",
	light_source = 1,
})

core.register_node("robot_escape:scissorsget", {
    description = "Gives you scissors",
	drawtype ="glasslike",
    tiles = {"scissorsget.png"},
	walkable = false,
	use_texture_alpha = "blend",
	post_effect_color = "#c4f12964",
    --groups = {cracky = 1},
	paramtype = "light",
	light_source = 1,
})

core.register_node("robot_escape:invclear", {
    description = "Clears your inventory",
	drawtype ="glasslike",
    tiles = {"invclear.png"},
	walkable = false,
	use_texture_alpha = "blend",
	post_effect_color = "#bf3c3064",
	paramtype = "light",
    --groups = {cracky = 1}
	light_source = 1,
})

core.register_tool("robot_escape:drill", {
    description = "A drill mod for your arm",
	inventory_image = "drill.png",
    tool_capabilities = {
        full_punch_interval = 0.5,
		max_drop_level = 0,
		groupcaps = {
            crumbly = {
                times = { 0.1, 0.3, 2 },
                uses = 0,
            },
            cracky = {
                times = { 0.5, 0.8, 2 },
                uses = 0,
            },
        },
		damage_groups = { fleshy = 1 },
    },
})

core.register_tool("robot_escape:scissors", {
    description = "Industrial grade robotic scissors",
	inventory_image = "scissors.png",
    tool_capabilities = {
        full_punch_interval = 0.5,
		max_drop_level = 0,
		groupcaps = {
            snappy = {
                times = { 0.5, 0.8, 2 },
                uses = 0,
            },
        },
		damage_groups = { fleshy = 1 },
    },
})


local pl = {}
local function getpi(player)
    local pi = pl[player]
    if not pi then pi = {}; pl[player] = pi end
    return pi
end

local function on_enter_drill(player, pi)
	local inv = player:get_inventory()
	local stack = ItemStack("robot_escape:drill 1")
	inv:add_item("main", stack)
end

local function on_enter_scissors(player, pi)
	local inv = player:get_inventory()
	local stack = ItemStack("robot_escape:scissors 1")
	inv:add_item("main", stack)
end

local function on_enter_clear(player, pi)
	local inv = player:get_inventory()
	local stack_a = ItemStack("robot_escape:drill 1")
	local stack_b = ItemStack("robot_escape:scissors 1")
	for i=1,inv:get_size("main") do
		inv:remove_item("main", stack_a)
		inv:remove_item("main", stack_b)
	end
end

local function on_leave(player, pi)

end

core.register_globalstep(function(dtime)
    for i, player in ipairs(core.get_connected_players()) do
        local pos = player:get_pos()
        pos.x = math.ceil(pos.x)
        pos.y = math.ceil(pos.y)
        pos.z = math.ceil(pos.z)
        local node = core.get_node(pos)
        local pi = getpi(player)
        if node.name == "robot_escape:drillget" then
            if (not pi.last_pass_pos) or (not pi.last_pass_pos:equals(pos)) then
                pi.last_pass_pos = pos
                on_enter_drill(player, pi)
            end
		elseif node.name == "robot_escape:scissorsget" then
			if (not pi.last_pass_pos) or (not pi.last_pass_pos:equals(pos)) then
                pi.last_pass_pos = pos
                on_enter_scissors(player, pi)
            end
		elseif node.name == "robot_escape:invclear" then
			if (not pi.last_pass_pos) or (not pi.last_pass_pos:equals(pos)) then
                pi.last_pass_pos = pos
                on_enter_clear(player, pi)
            end
        elseif pi.last_pass_pos then
            pi.last_pass_pos = nil
            --on_leave(player, pi)
        end
    end
end)

--[[
core.register_globalstep(function(dtime)
	
		
		local player = core.get_player_by_name("singleplayer")
		local pos = player:get_pos()
        local node = core.get_node({x=pos.x, y=pos.y+0.5, z=pos.z})
		local inv = player:get_inventory()
		if node.name == "robot_escape:drillget" then
			inv:add_item("robot_escape:drill", stack)
		elseif node.name == "robot_escape:scissorsget" then
			inv:add_item("robot_escape:scissors", stack)
		elseif node.name == "invclear" then
			inv:remove_item("robot_escape:drill", stack)
			inv:remove_item("robot_escape:scissors", stack)
		end
		
end)
--]]


core.register_alias("leaves", "robot_escape:leaves")
core.register_alias("wall", "robot_escape:prisonwall")
core.register_alias("metal", "robot_escape:metalwall")
core.register_alias("drillget", "robot_escape:drillget")
core.register_alias("scissorsget", "robot_escape:scissorsget")
core.register_alias("invclear", "robot_escape:invclear")
core.register_alias("drill", "robot_escape:drill")
core.register_alias("deep", "robot_escape:deeprock")
core.register_alias("grille", "robot_escape:grille")
core.register_alias("scissors", "robot_escape:scissors")