
core.register_node("re_core:prisonwall", {
    description = "A reminder of your situation",
    tiles = {"prisonwall.png"},
	groups = {cracky = 1},
	paramtype = "light",
	light_source = 1,
})
core.register_node("re_core:metalwall", {
    description = "Unbreakable",
    tiles = {"metalwall.png"},
	paramtype = "light",
	light_source = 1,
})
core.register_node("re_core:deeprock", {
    description = "Unbreakable",
    tiles = {"deepstone.png"},
	paramtype = "light",
	light_source = 1,
})

core.register_node("re_core:grille", {
    description = "A reminder of your freedom",
	drawtype = "nodebox",
    tiles = {
        "empty.png",
        "empty.png",
        "grille.png",
		"grille.png",
        "empty.png",
		"empty.png",
    },
	node_box = {
        type = "fixed",
        fixed = {
            {0, -0.5, -0.5, 0, 0.5, 0.5},
        },
    },
	groups = {snappy = 1},
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = "4dir",
	light_source = 1,
})

core.register_node("re_core:leaves", {
    description = "Leaves, not much to say about it",
	drawtype ="allfaces_optional",
    tiles = {"leavestext.png"},
	groups = {snappy = 1},
	use_texture_alpha = "clip",
	paramtype = "light",
	light_source = 1,
})

core.register_node("re_core:drillget", {
    description = "Gives you a drill",
	drawtype ="glasslike",
    tiles = {"drillget.png"},
	walkable = false,
	use_texture_alpha = "blend",
	post_effect_color = "#fffb1764",
    --groups = {cracky = 1},
	paramtype = "light",
	light_source = 1,
})

core.register_node("re_core:scissorsget", {
    description = "Gives you scissors",
	drawtype ="glasslike",
    tiles = {"scissorsget.png"},
	walkable = false,
	use_texture_alpha = "blend",
	post_effect_color = "#c4f12964",
    --groups = {cracky = 1},
	paramtype = "light",
	light_source = 1,
})

core.register_node("re_core:invclear", {
    description = "Clears your inventory",
	drawtype ="glasslike",
    tiles = {"invclear.png"},
	walkable = false,
	use_texture_alpha = "blend",
	post_effect_color = "#bf3c3064",
	paramtype = "light",
    --groups = {cracky = 1}
	light_source = 1,
})

core.register_tool("re_core:drill", {
    description = "A drill mod for your arm",
	inventory_image = "drill.png",
    tool_capabilities = {
        full_punch_interval = 0.5,
		max_drop_level = 0,
		groupcaps = {
            crumbly = {
                times = { 0.1, 0.3, 2 },
                uses = 0,
            },
            cracky = {
                times = { 0.5, 0.8, 2 },
                uses = 0,
            },
        },
		damage_groups = { fleshy = 1 },
    },
})

core.register_tool("re_core:scissors", {
    description = "Industrial grade robotic scissors",
	inventory_image = "scissors.png",
    tool_capabilities = {
        full_punch_interval = 0.5,
		max_drop_level = 0,
		groupcaps = {
            snappy = {
                times = { 0.5, 0.8, 2 },
                uses = 0,
            },
        },
		damage_groups = { fleshy = 1 },
    },
})


local pl = {}
local function getpi(player)
    local pi = pl[player]
    if not pi then pi = {}; pl[player] = pi end
    return pi
end

local function on_enter_drill(player, pi)
	local inv = player:get_inventory()
	local stack = ItemStack("re_core:drill 1")
	inv:add_item("main", stack)
end

local function on_enter_scissors(player, pi)
	local inv = player:get_inventory()
	local stack = ItemStack("re_core:scissors 1")
	inv:add_item("main", stack)
end

local function on_enter_clear(player, pi)
	local inv = player:get_inventory()
	local stack_a = ItemStack("re_core:drill 1")
	local stack_b = ItemStack("re_core:scissors 1")
	for i=1,inv:get_size("main") do
		inv:remove_item("main", stack_a)
		inv:remove_item("main", stack_b)
	end
end

core.register_globalstep(function(dtime)
    for i, player in ipairs(core.get_connected_players()) do
        local pos = player:get_pos()
        pos.x = math.ceil(pos.x)
        pos.y = math.ceil(pos.y)
        pos.z = math.ceil(pos.z)
        local node = core.get_node(pos)
        local pi = getpi(player)
        if node.name == "re_core:drillget" then
            if (not pi.last_pass_pos) or (not pi.last_pass_pos:equals(pos)) then
                pi.last_pass_pos = pos
                on_enter_drill(player, pi)
            end
		elseif node.name == "re_core:scissorsget" then
			if (not pi.last_pass_pos) or (not pi.last_pass_pos:equals(pos)) then
                pi.last_pass_pos = pos
                on_enter_scissors(player, pi)
            end
		elseif node.name == "re_core:invclear" then
			if (not pi.last_pass_pos) or (not pi.last_pass_pos:equals(pos)) then
                pi.last_pass_pos = pos
                on_enter_clear(player, pi)
            end
        elseif pi.last_pass_pos then
            pi.last_pass_pos = nil
        end
    end
end)


core.register_alias("leaves", "re_core:leaves")
core.register_alias("wall", "re_core:prisonwall")
core.register_alias("metal", "re_core:metalwall")
core.register_alias("drillget", "re_core:drillget")
core.register_alias("scissorsget", "re_core:scissorsget")
core.register_alias("invclear", "re_core:invclear")
core.register_alias("drill", "re_core:drill")
core.register_alias("deep", "re_core:deeprock")
core.register_alias("grille", "re_core:grille")
core.register_alias("scissors", "re_core:scissors")