local radius = 5 
local height = 20
local num_particles = 30

local function register_entity(name, mesh)
    minetest.register_entity(name, {
        physical = true,
        visual = "mesh",
        mesh = mesh,
        visual_size = {x = 4, y = 4},
        textures = {"tex.png"},
        on_activate = function(self)
            self.timer = 0
        end,
        on_step = function(self, dtime)
            self.timer = self.timer + dtime
            if self.timer > 5 then
                self.object:remove()
            end
        end,
    })
end

register_entity("azada:entity", "bloque.obj")
register_entity("azada:bloque_grado_1", "bloque_grado_1.obj")
register_entity("azada:bloque_grado_2", "bloque_grado_2.obj")
register_entity("azada:bloque_grado_3", "bloque_grado_3.obj")
register_entity("azada:bloque_grado_4", "bloque_grado_4.obj")

minetest.register_tool("azada:claymore", {
  description = "Claymore",
  inventory_image = "tool.png",
  wield_scale = {x = 3, y = 3, z = 3},
  on_use = function(itemstack, player, pointed_thing)
    if pointed_thing.type == "node" then
      local pos = pointed_thing.under
      local node_y_neg = minetest.get_node({x=pos.x, y=pos.y-1, z=pos.z}, {name="air"})
      local node_y = minetest.get_node({x=pos.x, y=pos.y, z=pos.z})
      if node_y_neg.name ~= "air" then 
        minetest.sound_play("punch", {
            pos = pos,
            gain = 1.0,
            max_hear_distance = 10,
        })
        local node_def = minetest.registered_nodes[node_y.name]
        local texture = node_def.tiles[1] or "tex.png"
        local positions = {
            {x = pos.x - 1, y = pos.y, z = pos.z},
            {x = pos.x + 1, y = pos.y, z = pos.z},
            {x = pos.x, y = pos.y - 0.5, z = pos.z},
            {x = pos.x, y = pos.y, z = pos.z - 1},
            {x = pos.x, y = pos.y, z = pos.z + 1},
            {x = pos.x - 1, y = pos.y, z = pos.z - 1},
            {x = pos.x + 1, y = pos.y, z = pos.z + 1},
            {x = pos.x + 1, y = pos.y, z = pos.z - 1},
            {x = pos.x - 1, y = pos.y, z = pos.z + 1},
        }

        for _, p in ipairs(positions) do
            minetest.set_node(p, {name = "air"})
        end
        local entities = {
            {pos = {x = pos.x + 1, y = pos.y - 0.3, z = pos.z - 1}, entity = "azada:entity"},
            {pos = {x = pos.x - 1, y = pos.y - 0.3, z = pos.z + 1}, entity = "azada:entity"},
            {pos = {x = pos.x + 1, y = pos.y - 0.3, z = pos.z + 1}, entity = "azada:entity"},
            {pos = {x = pos.x - 1, y = pos.y - 0.3, z = pos.z - 1}, entity = "azada:entity"},
            {pos = {x = pos.x, y = pos.y - 0.4, z = pos.z}, entity = "azada:entity"},
            {pos = {x = pos.x + 1, y = pos.y - 0.3, z = pos.z}, entity = "azada:bloque_grado_1"},
            {pos = {x = pos.x - 1, y = pos.y - 0.3, z = pos.z}, entity = "azada:bloque_grado_2"},
            {pos = {x = pos.x, y = pos.y - 0.3, z = pos.z + 1}, entity = "azada:bloque_grado_3"},
            {pos = {x = pos.x, y = pos.y - 0.3, z = pos.z - 1}, entity = "azada:bloque_grado_4"},
        }

        for _, e in ipairs(entities) do
            local obj = minetest.add_entity(e.pos, e.entity)
            if obj then
                obj:set_properties({textures = {texture}})
            end
        end

        for angle = 0, 360, 10 do
        local rad = math.rad(angle) 
        local x = pos.x + radius * math.cos(rad)
        local y = pos.y + 1 
        local z = pos.z + radius * math.sin(rad)
        local velocity = 2
        local particle_pos = {x = x, y = y, z = z}
        minetest.add_particle({
          pos = particle_pos,
          velocity = {
            x = (pos.x - x) * velocity,
            y = 0.5,
            z = (pos.z - z) * velocity
          },
          acceleration = {x = 0, y = -0.1, z = 0},
          expirationtime = 2,
          size = 2,
          collisiondetection = false,
          vertical = true,
          texture = "blanco.png", 
          glow = 10,
        })
        for i = 1, num_particles do
          local ratio = i / num_particles 
          local start_x = pos.x + radius * math.cos(angle) 
          local start_z = pos.z + radius * math.sin(angle) 
          local x = start_x * (1 - ratio) + pos.x * ratio 
          local y = pos.y + height * (1 - ratio)
          local z = start_z * (1 - ratio) + pos.z * ratio 
          local particle_pos = {x = x, y = y, z = z}
            minetest.add_particle({
            pos = particle_pos,
            velocity = {x = 0, y = -4, z = 0}, 
            acceleration = {x = 0, y = -8, z = 0},
            expirationtime = 4,
            size = 0.7,
            collisiondetection = false,
            vertical = true,
            texture = "morado.png", 
            glow = 5,
          })
        end
      end
      end 
      return itemstack
    end
  end,
})