
local pos_ramdom = math.random(1,3)

local function register_entity(name, mesh)
    minetest.register_entity(name, {
        physical = true,
        visual = "mesh",
        mesh = mesh,
        visual_size = {x = 5, y = 5},
        textures = {"tex.png"},
        on_activate = function(self)
            self.timer = 0
        end,
        on_step = function(self, dtime)
            self.timer = self.timer + dtime
            if self.timer > 5 then
                self.object:remove()
            end
        end,
    })
end

register_entity("azada:entity", "bloque.obj")
register_entity("azada:bloque_grado_1", "bloque_grado_1.obj")
register_entity("azada:bloque_grado_2", "bloque_grado_2.obj")
register_entity("azada:bloque_grado_3", "bloque_grado_3.obj")
register_entity("azada:bloque_grado_4", "bloque_grado_4.obj")

function particles(particles,texture)
          minetest.add_particle({
          pos = particles,
          acceleration = {x = 0, y = 10, z = 0},
          expirationtime = 0.5,
          size = 2,
          vertical = true,
          texture = texture, 
          glow = 3,
        })
end

function particles_down(particles,texture)
          minetest.add_particle({
          pos = particles,
          acceleration = {x = 0, y = -3, z = 0},
          expirationtime = 0.6,
          size = 2,
          vertical = true,
          texture = texture, 
          glow = 3,
        })
end

function generar_deformacion(pos)
      local pos_particle = {x = pos.x, y = pos.y, z = pos.z}
      local node_y_negative = minetest.get_node({x=pos.x, y=pos.y-1, z=pos.z}, {name="air"})
      local node_y = minetest.get_node({x=pos.x, y=pos.y, z=pos.z})
      local pos_particle_down = {x = pos.x, y = pos.y+1, z = pos.z}
      local node_x_pos_comprobacion = minetest.get_node({x=pos.x+ 1, y=pos.y, z=pos.z})
      local node_x_neg_comprobacion = minetest.get_node({x=pos.x- 1, y=pos.y, z=pos.z})
      local node_z_pos_comprobacion = minetest.get_node({x=pos.x, y=pos.y, z=pos.z + 1})
      local node_z_neg_comprobacion = minetest.get_node({x=pos.x, y=pos.y, z=pos.z - 1})
      local node_def = minetest.registered_nodes[node_y.name]
      local texture = node_def.tiles[1] or "tex.png"

      if node_y_negative.name         -----
      and node_x_pos_comprobacion.name 
      and node_x_neg_comprobacion.name
      and node_z_pos_comprobacion.name 
      and node_z_neg_comprobacion.name ~= "air"  then 

        local positions_up = {
            {x = pos_particle.x - pos_ramdom, y = pos_particle.y, z = pos_particle.z},
            {x = pos_particle.x + pos_ramdom, y = pos_particle.y, z = pos_particle.z},
            {x = pos_particle.x, y = pos_particle.y - 0.5, z = pos_particle.z},
            {x = pos_particle.x, y = pos_particle.y, z = pos_particle.z - pos_ramdom},
            {x = pos_particle.x, y = pos_particle.y, z = pos_particle.z + pos_ramdom},
            {x = pos_particle.x - pos_ramdom, y = pos_particle.y, z = pos_particle.z - pos_ramdom},
            {x = pos_particle.x + pos_ramdom, y = pos_particle.y, z = pos_particle.z + pos_ramdom},
            {x = pos_particle.x + pos_ramdom, y = pos_particle.y, z = pos_particle.z - pos_ramdom},
            {x = pos_particle.x - pos_ramdom, y = pos_particle.y, z = pos_particle.z + pos_ramdom},
            {x = pos_particle.x - pos_ramdom, y = pos_particle.y, z = pos_particle.z - pos_ramdom},
            {x = pos_particle.x + pos_ramdom, y = pos_particle.y, z = pos_particle.z + pos_ramdom},
            {x = pos_particle.x + pos_ramdom, y = pos_particle.y, z = pos_particle.z - pos_ramdom},
            {x = pos_particle.x - pos_ramdom, y = pos_particle.y, z = pos_particle.z + pos_ramdom},
        }
        local positions_down = {
            {x = pos_particle_down.x - pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z},
            {x = pos_particle_down.x + pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z},
            {x = pos_particle_down.x, y = pos_particle_down.y - 0.5, z = pos_particle_down.z},
            {x = pos_particle_down.x, y = pos_particle_down.y, z = pos_particle_down.z - pos_ramdom},
            {x = pos_particle_down.x, y = pos_particle_down.y, z = pos_particle_down.z + pos_ramdom},
            {x = pos_particle_down.x - pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z - pos_ramdom},
            {x = pos_particle_down.x + pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z + pos_ramdom},
            {x = pos_particle_down.x + pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z - pos_ramdom},
            {x = pos_particle_down.x - pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z + pos_ramdom},
            {x = pos_particle_down.x - pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z - pos_ramdom},
            {x = pos_particle_down.x + pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z + pos_ramdom},
            {x = pos_particle_down.x + pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z - pos_ramdom},
            {x = pos_particle_down.x - pos_ramdom, y = pos_particle_down.y, z = pos_particle_down.z + pos_ramdom},
        }
        local positions = {
            {x = pos.x - 1, y = pos.y, z = pos.z},
            {x = pos.x + 1, y = pos.y, z = pos.z},
            {x = pos.x, y = pos.y - 0.5, z = pos.z},
            {x = pos.x, y = pos.y, z = pos.z - 1},
            {x = pos.x, y = pos.y, z = pos.z + 1},
            {x = pos.x - 1, y = pos.y, z = pos.z - 1},
            {x = pos.x + 1, y = pos.y, z = pos.z + 1},
            {x = pos.x + 1, y = pos.y, z = pos.z - 1},
            {x = pos.x - 1, y = pos.y, z = pos.z + 1},
        }

        local entities = {
            {pos = {x = pos.x + 1, y = pos.y - 0.5, z = pos.z - 1}, entity = "azada:entity"},
            {pos = {x = pos.x - 1, y = pos.y - 0.5, z = pos.z + 1}, entity = "azada:entity"},
            {pos = {x = pos.x + 1, y = pos.y - 0.5, z = pos.z + 1}, entity = "azada:entity"},
            {pos = {x = pos.x - 1, y = pos.y - 0.5, z = pos.z - 1}, entity = "azada:entity"},
            {pos = {x = pos.x, y = pos.y - 0.6, z = pos.z}, entity = "azada:entity"},
            {pos = {x = pos.x + 1, y = pos.y - 0.5, z = pos.z}, entity = "azada:bloque_grado_1"},
            {pos = {x = pos.x - 1, y = pos.y - 0.5, z = pos.z}, entity = "azada:bloque_grado_2"},
            {pos = {x = pos.x, y = pos.y - 0.5, z = pos.z + 1}, entity = "azada:bloque_grado_3"},
            {pos = {x = pos.x, y = pos.y - 0.5, z = pos.z - 1}, entity = "azada:bloque_grado_4"},
        }

        for _, p in ipairs(positions) do
            minetest.set_node(p, {name = "air"})
        end
        for _, p in ipairs(positions_up) do
            particles(p,texture)
        end
        for _, p in ipairs(positions_down) do
            particles_down(p,texture)
        end
        for _, e in ipairs(entities) do
            local obj = minetest.add_entity(e.pos, e.entity)
            if obj then
                obj:set_properties({textures = {texture}})
            end
        end
        minetest.sound_play("punch", {
            pos = pos,
            gain = 1.0,
            max_hear_distance = 10,
        })

       end 

    end

minetest.register_tool("azada:claymore", {
    description = "Claymore",
    inventory_image = "tool.png",
    wield_scale = {x = 2, y = 2, z = 2},
    on_use = function(itemstack, user, pointed_thing)
        if pointed_thing.type == "object" then
            local entidad = pointed_thing.ref
            if entidad:is_player() or entidad:get_luaentity() then
                entidad:punch(user, 1.0, {
                    full_punch_interval = 1.0,
                    damage_groups = {fleshy = 8}, 
                }, nil)
                itemstack:add_wear(65535 / 100) 
                return itemstack
            end
        end

    if pointed_thing.type == "node" then
      local pos = pointed_thing.under
      local nodo = minetest.get_node({x=pos.x, y=pos.y, z=pos.z})
      local nodo =  nodo.name
      if nodo == "default:dirt_with_grass" 
      or nodo == "default:dry_dirt_with_dry_grass"
      or nodo == "default:stone" 
      or nodo == "default:cobble"
      or nodo == "default:dirt"
      or nodo == "default:sand"
      or nodo == "default:silver_sand"   then
        generar_deformacion(pos)
      end
      itemstack:add_wear(65535 / 100)
      return itemstack  
    end
  end,
})

minetest.register_craft({
    output = "azada:claymore",
    recipe = {
        {"default:obsidian_shard", "default:obsidian_shard", "default:obsidian_shard"},
        {"default:obsidian_shard", "default:mese_crystal", "default:obsidian_shard"},
        {"default:obsidian_shard", "default:obsidian_shard", "default:obsidian_shard"},
    }
})