
local function on_destruct(pos, node)
    local node_def = minetest.registered_nodes[node.name]
    if node_def then
        local pos_particle_1 = {x = pos.x-math.random(0, 0.4), y = pos.y, z = pos.z-math.random(0, 0.6)}
        local pos_particle_2 = {x = pos.x+math.random(0, 0.3), y = pos.y, z = pos.z-math.random(0, 0.6)}
        local pos_particle_3 = {x = pos.x-math.random(0, 0.6), y = pos.y, z = pos.z-math.random(0, 0.6)}
        local pos_particle_4= {x = pos.x-math.random(0, 0.6), y = pos.y, z = pos.z+math.random(00, 0.6)}

        local obj_1 = minetest.add_entity(pos_particle_1, "block_pys:fragmento")
        local obj_2 = minetest.add_entity(pos_particle_2, "block_pys:fragmento2")
        local obj_3 = minetest.add_entity(pos_particle_3, "block_pys:fragmento3")
        local obj_4 = minetest.add_entity(pos_particle_4, "block_pys:fragmento4")

        if obj_1 and obj_2 and obj_3 and obj_4 then
            obj_1:set_properties({textures = node_def.tiles})
            obj_2:set_properties({textures = node_def.tiles})
            obj_3:set_properties({textures = node_def.tiles})
            obj_4:set_properties({textures = node_def.tiles})
        end
    end
end

minetest.register_on_dignode(on_destruct)

local function modify_thrown_object()
    local thrown_object = minetest.registered_entities["block_pys:fragmento"]
    if thrown_object then
        local original_on_step = thrown_object.on_step
        thrown_object.on_step = function(self, dtime, move_vec)
        self.lifetime = (self.lifetime or 0) + dtime
        if self.lifetime > 2 then
            self.object:remove()
        end
            if original_on_step then
                original_on_step(self, dtime, move_vec)
            end
            local obj = self.object 
            if obj then
                local vel = obj:getvelocity()
                if vel then
                vel.y = vel.y - 10 * dtime
                if obj then 
                    obj:setvelocity(vel)
                end
                end
            end
        end
    end
    local thrown_object2 = minetest.registered_entities["block_pys:fragmento2"]
    if thrown_object2 then
        local original_on_step = thrown_object2.on_step
        thrown_object2.on_step = function(self, dtime, move_vec)
        self.lifetime = (self.lifetime or 0) + dtime
        if self.lifetime > 2 then
            self.object:remove()
        end
            if original_on_step then
                original_on_step(self, dtime, move_vec)
            end
            local obj = self.object 
            if obj then
                local vel = obj:getvelocity()
                if vel then
                vel.y = vel.y - 10 * dtime
                if obj then 
                    obj:setvelocity(vel)
                end
                end
            end
        end
    end
    local thrown_object3 = minetest.registered_entities["block_pys:fragmento3"]
    if thrown_object3 then
        local original_on_step = thrown_object3.on_step
        thrown_object3.on_step = function(self, dtime, move_vec)
        self.lifetime = (self.lifetime or 0) + dtime
        if self.lifetime > 2 then
            self.object:remove()
        end
            if original_on_step then
                original_on_step(self, dtime, move_vec)
            end
            local obj = self.object 
            if obj then
                local vel = obj:getvelocity()
                if vel then
                vel.y = vel.y - 10 * dtime
                if obj then 
                    obj:setvelocity(vel)
                end
                end
            end
        end
    end
        local thrown_object4 = minetest.registered_entities["block_pys:fragmento4"]
    if thrown_object4 then
        local original_on_step = thrown_object4.on_step
        thrown_object4.on_step = function(self, dtime, move_vec)
        self.lifetime = (self.lifetime or 0) + dtime
        if self.lifetime > 2 then
            self.object:remove()
        end
            if original_on_step then
                original_on_step(self, dtime, move_vec)
            end
            local obj = self.object 
            if obj then
                local vel = obj:getvelocity()
                if vel then
                vel.y = vel.y - 10 * dtime
                if obj then 
                    obj:setvelocity(vel)
                end
                end
            end
        end
    end
end

minetest.register_on_mods_loaded(modify_thrown_object)

function fragmento(name,mesh)

minetest.register_entity("block_pys:"..name,{
    physical = true,
    collide = true,
    collisionbox = {-0.125, 0, -0.125, 0.125, 0.125, 0.125},
     visual_size = {x=math.random(0.4, 0.6), y=math.random(0.4, 0.6)},
    gravity = 1,
    visual = "mesh",
    mesh = mesh,
})

end

fragmento("fragmento","bloque.obj")
fragmento("fragmento2","bloque2.obj")
fragmento("fragmento3","bloque3.obj")
fragmento("fragmento4","bloque4.obj")
