local function on_destruct(pos, node)
    local node_def = minetest.registered_nodes[node.name]
    if node_def then
        local pos_particle_1 = {x = pos.x-math.random(0, 0.4), y = pos.y, z = pos.z-math.random(0, 0.6)}
        local pos_particle_2 = {x = pos.x+math.random(0, 0.3), y = pos.y, z = pos.z-math.random(0, 0.6)}
        local pos_particle_3 = {x = pos.x-math.random(0, 0.6), y = pos.y, z = pos.z-math.random(0, 0.6)}
        local pos_particle_4 = {x = pos.x-math.random(0, 0.6), y = pos.y, z = pos.z+math.random(0, 0.6)}
        local pos_particle_5 = {x = pos.x-math.random(0.4, 0.2), y = pos.y+0.4, z = pos.z-math.random(0.3, 0.6)}
        local pos_particle_6 = {x = pos.x+math.random(0.3, 0.1), y = pos.y+0.3, z = pos.z-math.random(0.1, 0.6)}
        local pos_particle_7 = {x = pos.x-math.random(0.2, 0.6), y = pos.y+0.1, z = pos.z-math.random(0.5, 0.2)}
        local pos_particle_8 = {x = pos.x-math.random(0.1, 0.2), y = pos.y+0.2, z = pos.z+math.random(0.2, 0.3)}
        local obj_1 = minetest.add_entity(pos_particle_1, "block_pys:fragmento")
        local obj_2 = minetest.add_entity(pos_particle_2, "block_pys:fragmento2")
        local obj_3 = minetest.add_entity(pos_particle_3, "block_pys:fragmento3")
        local obj_4 = minetest.add_entity(pos_particle_4, "block_pys:fragmento4")
        local obj_5 = minetest.add_entity(pos_particle_5, "block_pys:fragmento4")
        local obj_6 = minetest.add_entity(pos_particle_6, "block_pys:fragmento4")
        local obj_7 = minetest.add_entity(pos_particle_7, "block_pys:fragmento4")
        local obj_8 = minetest.add_entity(pos_particle_8, "block_pys:fragmento4")
        if obj_1 and obj_2 and obj_3 and obj_4 and obj_5 and obj_6 and obj_7 and obj_8 then
            obj_1:set_properties({textures = node_def.tiles})
            obj_2:set_properties({textures = node_def.tiles})
            obj_3:set_properties({textures = node_def.tiles})
            obj_4:set_properties({textures = node_def.tiles})
            obj_5:set_properties({textures = node_def.tiles})
            obj_6:set_properties({textures = node_def.tiles})
            obj_7:set_properties({textures = node_def.tiles})
            obj_8:set_properties({textures = node_def.tiles})
            obj_1:set_rotation({x = math.random(0, 360), y = math.random(0, 360), z = math.random(0, 360)})
            obj_2:set_rotation({x = math.random(0, 360), y = math.random(0, 360), z = math.random(0, 360)})
            obj_3:set_rotation({x = math.random(0, 360), y = math.random(0, 360), z = math.random(0, 360)})
            obj_4:set_rotation({x = math.random(0, 360), y = math.random(0, 360), z = math.random(0, 360)})
            obj_5:set_rotation({x = math.random(0, 360), y = math.random(0, 360), z = math.random(0, 360)})
            obj_6:set_rotation({x = math.random(0, 360), y = math.random(0, 360), z = math.random(0, 360)})
            obj_7:set_rotation({x = math.random(0, 360), y = math.random(0, 360), z = math.random(0, 360)})
            obj_8:set_rotation({x = math.random(0, 360), y = math.random(0, 360), z = math.random(0, 360)})
        end
    end
end

minetest.register_on_dignode(on_destruct)

local function modify_thrown_object()
    local function create_on_step_handler()
        return function(self, dtime, moveresult)
            self.lifetime = (self.lifetime or 0) + dtime
            
            if self.lifetime > 5 then
                self.object:remove()
                return
            end
            
            local obj = self.object
            if not obj then return end
            
            if moveresult and moveresult.collides and moveresult.touching_ground then
                if not self.has_stopped then
                    obj:set_velocity({x=0, y=0, z=0})
                    obj:set_acceleration({x=0, y=0, z=0})
                    obj:set_properties({
                        physical = false,
                        collide_with_objects = false,
                        collisionbox = {0,0,0,0,0,0} 
                    })
                    self.has_stopped = true
                    minetest.after(2, function()
                        if obj and obj:get_pos() then
                            obj:remove()
                        end
                    end)
                end
                return
            end
            
            if not self.has_stopped then
                local rot = obj:get_rotation()
                if rot then
                    rot.y = rot.y + 5 * dtime 
                    obj:set_rotation(rot)
                end
            end
            
            -- Gravedad
            local vel = obj:getvelocity()
            if vel then
                vel.y = vel.y - 10 * dtime
                obj:setvelocity(vel)
            end
        end
    end

    local fragments = {
        "block_pys:fragmento",
        "block_pys:fragmento2",
        "block_pys:fragmento3",
        "block_pys:fragmento4"
    }
    
    for _, fragment_name in ipairs(fragments) do
        local thrown_object = minetest.registered_entities[fragment_name]
        if thrown_object then
            thrown_object.on_step = create_on_step_handler()
        end
    end
end

minetest.register_on_mods_loaded(modify_thrown_object)

function fragmento(name, mesh)
    minetest.register_entity("block_pys:"..name, {
        physical = true,
        collide = true,
        collisionbox = {-0.125, 0, -0.125, 0.125, 0.125, 0.125},
        visual_size = {x = math.random(0.3, 1), y = math.random(0.3, 1), z = math.random(0.3, 1)},
        gravity = 1,
        visual = "mesh",
        mesh = mesh,
        pointable = false,
        collide_with_objects = false,
        static_save = false,
    })
end

fragmento("fragmento", "bloque.obj")
fragmento("fragmento2", "bloque2.obj")
fragmento("fragmento3", "bloque3.obj")
fragmento("fragmento4", "bloque4.obj")