
local capital = {
    activa = true,
    posicion = {x = 0, y = 15000, z = 0},
    jugadores_permitidos = true
}

local archivo_guardado = minetest.get_worldpath() .. "/capital_flotante_simple.dat"

local function guardar_config()
    local file = io.open(archivo_guardado, "w")
    if file then
        file:write(minetest.serialize(capital))
        file:close()
    end
end

local function cargar_config()
    local file = io.open(archivo_guardado, "r")
    if file then
        local datos = minetest.deserialize(file:read("*all"))
        file:close()
        if datos then
            capital = datos
        end
    end
end

minetest.after(0, cargar_config)

minetest.register_chatcommand("elysium", {
    description = "Teleport to the elysium",
    func = function(name)
        if not capital.activa then
            return false, "The elysium is currently disabled.."
        end
        if not capital.jugadores_permitidos then
            return false, "El acceso a la elysium está restringido."
        end
        
        local jugador = minetest.get_player_by_name(name)
        if jugador then
            jugador:set_pos(capital.posicion)
            return true, "¡welcome to The elysium!"
        end
        return false, "Error:Teleported."
    end
})


minetest.register_chatcommand("set_elysium", {
    description = "Change the location of the elysium to your current position",
    privs = {server = true},
    func = function(name)
        local jugador = minetest.get_player_by_name(name)
        if jugador then
            capital.posicion = jugador:get_pos()
            capital.posicion.y = capital.posicion.y + 1  
            guardar_config()
            return true, "elysium location updated and saved."
        end
        return false, "Error"
    end
})


minetest.register_chatcommand("access_to_the_elysium", {
    description = "Allow or deny players access to the capital",
    privs = {server = true},
    func = function(name)
        capital.jugadores_permitidos = not capital.jugadores_permitidos
        guardar_config()
        local estado = capital.jugadores_permitidos and "allow" or "deny"
        return true, "acces to the capital " .. estado .. " to players."
    end
})