local player_actions = {}
local S = minetest.get_translator("control")

function show_actions(player, selected_player)
    local name = player:get_player_name()
    local actions = player_actions[selected_player] or S("There are no shares registered.")

    local formspec = "size[13,10]" ..
                     "textarea[1,1;12,8;mostrar;;" .. actions .. "]"..
                    "label[2,0.5;Acciones de " .. selected_player .. ":]" ..
                     "button[10,8;2.2,2;actualizar;actualizar]"..
                     "button_exit[0.5,9;7,1;exit;Salir]"

    minetest.show_formspec(player:get_player_name(), "player_actions:show_actions", formspec)
        minetest.register_on_player_receive_fields(function(player, formname, fields)
            if fields.actualizar then
               show_actions(player, selected_player)

            end
        end)
    end


minetest.register_on_joinplayer(function(player)
    local pos = player:get_pos() 
    local pos_str = string.format(" Posición: (%.2f, %.2f, %.2f)", pos.x, pos.y, pos.z)
    local name = player:get_player_name()
    player_actions[name] = "" 
    player_actions[name] = player_actions[name] .. name .. S(" has entered the game.") .. "\n"
    player_actions[name] = player_actions[name] .. name .."".. pos_str.. "\n"
end)

minetest.register_on_leaveplayer(function(player)
    local name = player:get_player_name()
    player_actions[name] = nil 
end)
minetest.register_on_chat_message(function(name, message)
    player_actions[name] = player_actions[name] or ""
    player_actions[name] = player_actions[name] .. name .. S(" send a message: ") .. message .. "\n"
end)

minetest.register_on_respawnplayer(function(player)
    local name = player:get_player_name()
    player_actions[name] = player_actions[name] or ""
    player_actions[name] = player_actions[name] .. name .. S(" has reappeared")
end)

minetest.register_on_player_hpchange(function(player, hp_change)
    local name = player:get_player_name()
    player_actions[name] = player_actions[name] or ""
    if hp_change < 0 then
        player_actions[name] = player_actions[name] .. name .. S(" has lost his life.").. "\n" 
    elseif hp_change > 0 then
        player_actions[name] = player_actions[name] .. name .. S(" has gained life.").. "\n" 
    end
end)


local function on_place_node(pos, node, placer, oldnode, itemstack)
    if not placer then return end 
    local name = placer:get_player_name()
    local node_name = itemstack:get_name()
    local posb = minetest.pos_to_string(pos)
    player_actions[name] = player_actions[name] or ""
    player_actions[name] = player_actions[name] .. name .. S(" has placed a block: ") .. node_name .. " > "..posb.."\n"
end


minetest.register_on_placenode(on_place_node)

minetest.register_on_dignode(function(pos, node, player)
    if not player then return end  
    local name = player:get_player_name()
    local node_name = node.name
    local posb = minetest.pos_to_string(pos)
    player_actions[name] = player_actions[name] or ""
    player_actions[name] = player_actions[name] .. name .. S(" removed a block: ") .. node_name .. " > "..posb.."\n"

end)

minetest.register_chatcommand("control", {
    params = "<nombre>",
    description = "Muestra las acciones del jugador especificado.",
    func = function(name, param)
        if not minetest.check_player_privs(name, {server=true}) then
            return false, S("You do not have privileges to use this command.")
        end
        if param == "" then
            return false, S("Please specify the name of a player.")
        end

        local target_player = minetest.get_player_by_name(param)
        if not target_player then
            return false, S("Player not found: ") .. param
        end

        show_actions(minetest.get_player_by_name(name), param)
    end,
})
