local super_speed_active = {}
function particle_pos(pos)    
    for i = 1, 10 do
        minetest.add_particle({
        pos = {x=pos.x, y=pos.y, z=pos.z},
        velocity = {x=math.random(-1, 1), z=math.random(-1, 1), y=math.random(-1, 1)},
        expirationtime = 1,
        size = 2,
        texture = "particle_f.png",
        }) 
    end
end

minetest.register_privilege("superspeed", {
    description = "superspeed",
    give_to_singleplayer = false,
})

minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        local name = player:get_player_name()
        local pos = player:get_pos()
        local controls = player:get_player_control()
        if minetest.check_player_privs(name, {superspeed = true}) then
        if controls.aux1 then 
            if not super_speed_active[name] then
                super_speed_active[name] = true
                player:set_physics_override({speed = 10, jump = 2.0}) 
                particle_pos(pos)    
            end
        else
            if super_speed_active[name] then
                super_speed_active[name] = false
                player:set_physics_override({speed = 1.0, jump = 1.0}) 
            end
        end
    end
    end
end)