function smoking(pos)
            minetest.add_particle({
            pos = pos,
            velocity = {x=1, y=1, z=0},
            acceleration = {x=0, y=0, z=0},
            expirationtime = 1.5,
            size = 80,
            texture = "smoke.png", 
        })
end
minetest.register_entity("grenades_gb:molotov", {
    initial_properties = {
        physical = true,
        collide_with_objects = true,
        collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
        visual = "sprite", 
        textures = {"molotov.png"},
        mass = 1,
        static_save = false,
        visual_size = {x = 0.5, y = 0.5},
    },
    
    on_activate = function(self, staticdata)
        self.object:set_velocity({x = 1, y = 1, z = 1}) 
        self.gravity = -15
        self.timer = 0
    end,
    
    on_step = function(self, dtime)
        local vel = self.object:get_velocity()
        vel.y = vel.y + self.gravity * dtime
        self.object:set_velocity(vel)

        self.timer = self.timer + dtime
        if self.timer > 1 then 
            self:explode()
            return
        end
    end,

    on_punch = function(self, hitter)
        self:explode()
    end,

    on_collide_with = function(self, other)
        self:explode()
    end,

    explode = function(self)
        local pos = self.object:get_pos()
        if not pos then return end 

        for x = -1, 1 do
        for y = 0, 0 do
        for z = -1, 1 do
            local fire_pos = {x = pos.x + x, y = pos.y + y, z = pos.z + z}
            local node = minetest.get_node(fire_pos)
            if node.name == "air" then
                minetest.set_node(fire_pos, {name = "fire:basic_flame"})
                minetest.after(5, function()
                    minetest.set_node(fire_pos, {name = "air"})
                end)
            end
        end
        end
        end
        minetest.sound_play("explosion", {
            pos = pos,
            gain = 1.0,
            max_hear_distance = 10,
        })
        self.object:remove() 
    end,
})

minetest.register_tool("grenades_gb:molotov_la", {
    description = "molotov",
    inventory_image = "molotov.png", 
    on_use = function(itemstack, user, pointed_thing)
        local pos = user:get_pos()
        pos.y = pos.y + 1.8
        local dir = user:get_look_dir()
        
        local obj = minetest.add_entity(pos, "grenades_gb:molotov")
        
        if obj then
            obj:set_velocity({
                x = dir.x * 5, 
                y = dir.y * 5 + 5, 
                z = dir.z * 5
            })
        end
        
        itemstack:take_item()
        return itemstack
    end,
})
----
minetest.register_entity("grenades_gb:grenade_entity_smoke", {
    initial_properties = {
        physical = true,
        collide_with_objects = true,
        collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
        visual = "sprite", 
        textures = {"grenade_smoke.png"},
        mass = 1,
        static_save = false,
        visual_size = {x = 0.5, y = 0.5},
    },
    
    on_activate = function(self, staticdata)
        self.object:set_velocity({x = 1, y = 1, z = 1}) 
        self.gravity = -15
        self.timer = 0
    end,
    
    on_step = function(self, dtime)
        local vel = self.object:get_velocity()
        vel.y = vel.y + self.gravity * dtime
        self.object:set_velocity(vel)

        self.timer = self.timer + dtime
        if self.timer > 1 then 
            self:explode()
            return
        end
    end,

    on_punch = function(self, hitter)
        self:explode()
    end,

    on_collide_with = function(self, other)
        self:explode()
    end,

    explode = function(self)
        local pos = self.object:get_pos()
        if not pos then return end 
        smoking(pos)
        minetest.after(1, function()
        smoking(pos) 
        end)
        minetest.after(2, function()
        smoking(pos) 
        end)  
        minetest.after(3, function()
        smoking(pos) 
        end) 
         minetest.sound_play("explosion", {
            pos = pos,
            gain = 1.0,
            max_hear_distance = 10,
        })
        self.object:remove() 
    end,
})

minetest.register_tool("grenades_gb:grenade_launcher_smoke", {
    description = "smoke Grenade",
    inventory_image = "grenade_smoke.png", 
    on_use = function(itemstack, user, pointed_thing)
        local pos = user:get_pos()
        pos.y = pos.y + 1.8
        local dir = user:get_look_dir()
        
        local obj = minetest.add_entity(pos, "grenades_gb:grenade_entity_smoke")
        
        if obj then
            obj:set_velocity({
                x = dir.x * 5, 
                y = dir.y * 5 + 5, 
                z = dir.z * 5
            })
        end
        
        itemstack:take_item()
        return itemstack
    end,
})
------------------
minetest.register_entity("grenades_gb:grenade_entity", {
    initial_properties = {
        physical = true,
        collide_with_objects = true,
        collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
        visual = "sprite", 
        textures = {"grenade.png"},
        mass = 1,
        static_save = false,
        visual_size = {x = 0.5, y = 0.5},
    },
    
    on_activate = function(self, staticdata)
        self.object:set_velocity({x = 1, y = 1, z = 1}) 
        self.gravity = -15
        self.timer = 0
    end,
    
    on_step = function(self, dtime)
        local vel = self.object:get_velocity()
        vel.y = vel.y + self.gravity * dtime
        self.object:set_velocity(vel)

        self.timer = self.timer + dtime
        if self.timer > 1 then 
            self:explode()
            return
        end
    end,

    on_punch = function(self, hitter)
        self:explode()
    end,

    on_collide_with = function(self, other)
        self:explode()
    end,

    explode = function(self)
        local pos = self.object:get_pos()
        if not pos then return end 
        minetest.add_particle({
            pos = pos,
            velocity = {x=0, y=0, z=0},
            acceleration = {x=0, y=0, z=0},
            expirationtime = 1,
            size = 10,
            texture = "smoke.png", 
        })
         minetest.sound_play("explosion", {
            pos = pos,
            gain = 1.0,
            max_hear_distance = 10,
        })


        local radius = 3
        for _, player in ipairs(minetest.get_connected_players()) do
            local player_pos = player:get_pos()
            if player_pos then 
                local distance = vector.distance(pos, player_pos)
                if distance <= radius then
                    player:set_hp(player:get_hp() - 10) 
                end
            end
        end

        self.object:remove() 
    end,
})

minetest.register_tool("grenades_gb:grenade_launcher", {
    description = "Grenade",
    inventory_image = "grenade.png", 
    on_use = function(itemstack, user, pointed_thing)
        local pos = user:get_pos()
        pos.y = pos.y + 1.8
        local dir = user:get_look_dir()
        
        local obj = minetest.add_entity(pos, "grenades_gb:grenade_entity")
        
        if obj then
            obj:set_velocity({
                x = dir.x * 5, 
                y = dir.y * 5 + 5, 
                z = dir.z * 5
            })
        end
        
        itemstack:take_item()
        return itemstack
    end,
})
    minetest.register_craft({
        output = "grenades_gb:grenade_launcher",
        recipe = {
            {"default:steel_ingot", "tnt:gunpowder", "default:steel_ingot"},
            {"default:steel_ingot", "tnt:gunpowder", "default:steel_ingot"},
            {"", "", ""},
        },
    })
    
    minetest.register_craft({
        output = "grenades_gb:molotov_la",
        recipe = {
            {"", "tnt:gunpowder", ""},
            {"", "vessels:glass_bottle", ""},
            {"", "", ""},
        },
    })
    minetest.register_craft({
        output = "grenades_gb:grenade_launcher_smoke",
        recipe = {
            {"default:steel_ingot", "tnt:gunpowder", "default:steel_ingot"},
            {"", "default:steel_ingot", ""},
            {"", "", ""},
        },
    })