local death_count = 0 
local message_count = 0 
local messages = {}
minetest.register_on_punchplayer(function(player, hitter, _, _, _, damage)
    local hitter_name = hitter:get_player_name()
   local player_name = player:get_player_name()
   
   if not (hitter and hitter:is_player()) then
      return 
   end

   local hp = player:get_hp()
   if hp - damage > 0 or hp <= 0 then
      return 
   end
    death_count = death_count + 1
    message_count = message_count + 1

    if message_count == 5 then
        message_count = 0
    end
    local new_message = {
        text = "" .. hitter_name .. "  Killed  " .. player_name .. "",
        number = 0xFF0000,
        size = 20,
    }

    table.insert(messages, 1, new_message)

    if #messages > 5 then
        table.remove(messages) 
    end
   
   death_count = death_count + 1

   for _, p in pairs(minetest.get_connected_players()) do

      local position_y = 0.7 + (message_count  * 0.05)

        local hud_text_id = p:hud_add({
            hud_elem_type = "text",
            position = {x = 0.1, y = position_y},
            text = new_message.text,
            number = new_message.number,
            alignment = {x = 0, y = 0},
            offset = {x = 0, y = 0},
            size = new_message.size,
        })
      minetest.after(15, function()
         p:hud_remove(hud_text_id)
      end)
   end
end)