function register_monster(
name,       --1
mesh,       --2
textures,   --3
tipo_ataque,--4
pasivo,     --5
size_1,     --6
size_2,
speed,
hp)     --7

minetest.register_entity(name, {
        initial_properties = {
            visual = "mesh",
            mesh = mesh,
            hp_max = hp,
            textures = {textures},
            visual_size = {x = size_1, y = size_2},
            collisionbox = {-0.5, 0, -0.5, 0.5, 0.5, 0.5},
            physical = true,
        },
    speed = speed,
    turn_speed = 100,
    pasivo = pasivo, 
    target = nil,
    attack_range = 3, 
    view_range = 20, 
    state = "idle",
    wait_time = 0,
    wander_timer = 0,
    wander_direction = {x = 0, y = 0, z = 0},
    attack_cooldown = 0, 

    on_activate = function(self, staticdata)
        if staticdata then
            self.pasivo = pasivo
        end
    end,
    on_step = function(self, dtime)
    if tipo_ataque == "air" then
    local pos = self.object:get_pos()
    if not pos then return end


    self.wait_time = self.wait_time - dtime
    self.wander_timer = self.wander_timer - dtime
    self.attack_cooldown = self.attack_cooldown - dtime


    local players = minetest.get_connected_players()
    local closest_player = nil
    local closest_distance = self.view_range

    for _, player in ipairs(players) do
        local player_pos = player:get_pos()
        local distance = vector.distance(pos, player_pos)

        if distance < closest_distance then
            closest_player = player
            closest_distance = distance
        end
    end

    if self.state == "idle" then
        self.object:set_velocity({x = 0, y = 0, z = 0}) 
        if self.wait_time <= 0 then
            self.state = "wander"
            self.wander_timer = math.random(3, 7) 
            self.wander_direction = {
                x = math.random(-10, 10) / 10,
                y = math.random(-10, 10) / 10, 
                z = math.random(-10, 10) / 10,
            }
        end

    elseif self.state == "wander" then
        -- Estado de deambular
        if self.wander_timer <= 0 then
            self.state = "idle"
            self.wait_time = math.random(2, 5) 
        else
           
            local dir = self.wander_direction
            self.object:set_velocity(vector.multiply(dir, self.speed / 2))
        end

    elseif self.state == "chase" then

        if closest_player and closest_distance <= self.view_range then
            local target_pos = closest_player:get_pos()
            local dir = vector.direction(pos, target_pos) 

            local yaw = math.atan2(dir.z, dir.x) - math.pi / 2

            local pitch = -math.atan2(dir.y, math.sqrt(dir.x * dir.x + dir.z * dir.z))

            self.object:set_rotation({x = pitch, y = yaw, z = 0})

            if closest_distance <= self.attack_range then
                if self.attack_cooldown <= 0 then
                    self:attack_target()
                    self.attack_cooldown = 2 
                end
            else

                self.object:set_velocity(vector.multiply(dir, self.speed))
            end
        else
           
            self.state = "wander"
            self.wander_timer = math.random(3, 7)
          
            self.wander_direction = {
                x = math.random(-10, 10) / 10,
                y = math.random(-10, 10) / 10, 
                z = math.random(-10, 10) / 10,
            }
        end
    end

    if closest_player and closest_distance <= self.view_range and not self.pasivo then
        self.state = "chase"
        self.target = closest_player
    end
end
end,

    attack_target = function(self)
        if self.target then
            self.target:set_hp(self.target:get_hp() - 2)
        end
    end,

    get_staticdata = function(self)
        return minetest.serialize({pasivo = self.pasivo})
    end,
})
end


function register_egg(name,textures,description)

minetest.register_tool(name, {
  description = description,
  inventory_image = textures,
  wield_scale = {x = 2, y = 2, z = 2},
on_use = function(itemstack, player, pointed_thing)
  if pointed_thing.type == "node" then
    local pos = pointed_thing.under
    minetest.add_entity(pos, name)
    itemstack:take_item()
  end
  return itemstack
end,
})
end
