-- Función para registrar un monstruo
function register_monster(
    name,       -- Nombre de la entidad
    mesh,       -- Malla de la entidad
    textures,   -- Texturas de la entidad
    attack_type,-- Tipo de ataque
    pasivo,     -- Comportamiento pasivo
    size_x,     -- Tamaño en X
    size_y,     -- Tamaño en Y
    speed,      -- Velocidad
    hp,         -- Puntos de vida
    sound,      --sonido de ataque
    name_entity --para el hud
)

    minetest.register_entity(name, {
        initial_properties = {
            visual = "mesh",
            mesh = mesh,
            hp_max = hp,
            textures = {textures},
            visual_size = {x = size_x, y = size_y},
            collisionbox = {-1, 1, -1, 1, 4, 1},
            physical = true,
        },
        speed = speed,
        turn_speed = 100,
        pasivo = pasivo,
        target = nil,
        attack_range = 3,
        view_range = 20,
        state = "idle",
        wait_time = 0,
        wander_timer = 0,
        wander_direction = {x = 0, y = 0, z = 0},
        attack_cooldown = 0,
        health = hp, 
        hud_id = nil,
        hud_name_id = nil,

        update_health_hud = function(self, player)
         
            local normalized_health = math.floor((self.health / hp) * 50)

            if not self.hud_id then

                self.hud_id = player:hud_add({
                    hud_elem_type = "statbar",
                    position = {x = 0.3,y = 0.1}, 
                    size = {x = 16, y = 16},  
                    offset = {x = 0, y = -10},
                    text = "hud.png",     
                    number = normalized_health, 
                    alignment = {x = 0, y = -1},
                    scale = {x = 1, y = 1},      
                })
            else
                player:hud_change(self.hud_id, "number", normalized_health)
            end
              local hud_name_entity = { 
                  text = name_entity,       
                  number = 0xFF0000,

              }
            if not self.hud_name_id then
                self.hud_name_id = player:hud_add({
                    hud_elem_type = "text",
                    position = {x = 0.5,y = 0.1},
                    size = {x = 1, y = 1},  
                    offset = {x = 0, y = -10},
                    text = hud_name_entity.text,
                    number = hud_name_entity.number,    
                    alignment = {x = 0, y = -1},
                    scale = {x = 100, y = 100},   
                    number = 0xFFFFFF,          
                })
            else
                player:hud_change(self.hud_name_id, "text", name_entity)
            end

        end,

        hide_health_hud = function(self, player)
            if self.hud_id then
                player:hud_remove(self.hud_id)
                self.hud_id = nil
            end
            if self.hud_name_id then
                player:hud_remove(self.hud_name_id)
                self.hud_name_id = nil
            end
        end,

        on_activate = function(self, staticdata)
            if staticdata then
                self.pasivo = pasivo
            end
            self.health = self.hp_max
        end,

        on_step = function(self, dtime)
            local pos = self.object:get_pos()
            if not pos then return end

            self.wait_time = self.wait_time - dtime
            self.wander_timer = self.wander_timer - dtime
            self.attack_cooldown = self.attack_cooldown - dtime

            local players = minetest.get_connected_players()
            local closest_player = nil
            local closest_distance = self.view_range

            for _, player in ipairs(players) do
                local player_pos = player:get_pos()
                local distance = vector.distance(pos, player_pos)

                if distance < closest_distance then
                    closest_player = player
                    closest_distance = distance
                end
            end

            if self.state == "idle" then
                self.object:set_velocity({x = 0, y = 0, z = 0})
                if self.wait_time <= 0 then
                    self.state = "wander"
                    self.wander_timer = math.random(3, 7)
                    self.wander_direction = {
                        x = math.random(-10, 10) / 10,
                        y = math.random(-10, 10) / 10,
                        z = math.random(-10, 10) / 10,
                    }
                end
            elseif self.state == "wander" then
                if self.wander_timer <= 0 then
                    self.state = "idle"
                    self.wait_time = math.random(2, 5)
                else
                    local dir = self.wander_direction
                    self.object:set_velocity(vector.multiply(dir, self.speed / 2))
                    local yaw = math.atan2(dir.z, dir.x) - math.pi / 2
                    local pitch = math.atan2(dir.y, math.sqrt(dir.x * dir.x + dir.z * dir.z))
                    self.object:set_rotation({x = pitch, y = yaw, z = 0})
                end
            elseif self.state == "chase" then
                if closest_player and closest_distance <= self.view_range then
                    local target_pos = closest_player:get_pos()
                    local dir = vector.direction(pos, target_pos)
                    local yaw = math.atan2(dir.z, dir.x) - math.pi / 2
                    local pitch = math.atan2(dir.y, math.sqrt(dir.x * dir.x + dir.z * dir.z))
                    self.object:set_rotation({x = pitch, y = yaw, z = 0})

                    if closest_distance <= self.attack_range then
                        if self.attack_cooldown <= 0 then
                            self:attack_target()
                            self.attack_cooldown = 2
                        end
                    else
                        self.object:set_velocity(vector.multiply(dir, self.speed))
                    end
                else
                    self.state = "wander"
                    self.wander_timer = math.random(3, 7)
                    self.wander_direction = {
                        x = math.random(-10, 10) / 10,
                        y = math.random(-10, 10) / 10,
                        z = math.random(-10, 10) / 10,
                    }
                end
            end

            if closest_player and closest_distance <= self.view_range and not self.pasivo then
                self.state = "chase"
                self.target = closest_player
            end

            -- Actualizar la barra de vida para los jugadores cercanos
            for _, player in ipairs(players) do
                local player_pos = player:get_pos()
                local distance = vector.distance(pos, player_pos)

                if distance <= self.view_range then
                    self:update_health_hud(player)
                else
                    self:hide_health_hud(player)
                end
            end
        end,

        attack_target = function(self)
            if self.target then
                self.target:set_hp(self.target:get_hp() - 2)
                if sound then
                    for _, player in ipairs(minetest.get_connected_players()) do
                        minetest.sound_play(sound, {
                            to_player = player:get_player_name(),
                            gain = 1,
                        })
                    end
                end
            end
        end,

        get_staticdata = function(self)
            return minetest.serialize({pasivo = self.pasivo})
        end,
    })
end

function register_egg(name,textures,description)

minetest.register_tool(name, {
  description = description,
  inventory_image = textures,
  wield_scale = {x = 1, y = 1, z = 1},
  on_use = function(itemstack, player, pointed_thing)
    if pointed_thing.type == "node" then
        local pos = pointed_thing.under
        minetest.add_entity(pos, name)
        itemstack:take_item()
    end
    return itemstack
    end,
    })

end

