
minetest.register_chatcommand("ping", {
    description = "show your latency (ping)",
    func = function(name)
        local player = minetest.get_player_by_name(name)
        if not player then
            return false, "player no found"
        end
        
        local stats = minetest.get_player_information(name)
        if stats and stats.avg_rtt  then
            local ping = math.floor(stats.avg_rtt  * 1000) 
            return true, "your ping is: " .. ping .. " ms"
        else
            return false, "no ping information "
        end
    end
})

minetest.log("action", "[MOD] ping cargado correctamente")