kills = {}
deaths = {}
kills_para_resumen = {}
muertes_para_resumen = {}

local death_count = 0 
local mata_sin_morir = {}
local tiempo_para_guardar = 300
local path = minetest.get_modpath("pvp_center")
local current_index = 1

local function cargar_estaditicas_archivo()
    local file = io.open(minetest.get_worldpath() .. "/stats.txt", "r")
    if file then
        for line in file:lines() do
            local player_name, kill_count, death_count = line:match("([^:]+):(%d+):(%d+)")
            if player_name and kill_count and death_count then
                kills[player_name] = tonumber(kill_count)
                deaths[player_name] = tonumber(death_count)
            end
        end
        file:close()
    end
end

local function guardar_estaditicas_archivo()
    local file = io.open(minetest.get_worldpath() .. "/stats.txt", "w")
    if file then
        for player_name, kill_count in pairs(kills) do
            local death_count = deaths[player_name] or 0
            file:write(player_name .. ":" .. kill_count .. ":" .. death_count .. "\n")
        end
        file:close()
    end
end

local function register_kill(killer, victim)
    local victim = victim:get_player_name()
    kills[killer] = (kills[killer] or 0) + 1
    kills_para_resumen[killer] = (kills_para_resumen[killer] or 0) + 1
end
local function register_death(player_name)
    if not muertes_para_resumen[player_name] then
        muertes_para_resumen[player_name] = 0
    end
    if not deaths[player_name] then
        kills[player_name] = 0
        deaths[player_name] = 0
    end
    deaths[player_name] = deaths[player_name] + 1
    deaths[muertes_para_resumen] = muertes_para_resumen[player_name] + 1
end

minetest.register_on_dieplayer(function(victim)
    local killer_name = victim:get_meta():get_string("killer")
    if killer_name and killer_name ~= "" then
        register_kill(killer_name,victim)
    end
    register_death(victim:get_player_name())
end)

minetest.register_on_punchplayer(function(puncher, punched)
    if puncher and punched and puncher:is_player() and punched:is_player() then
        punched:get_meta():set_string("killer", puncher:get_player_name())
    end
end)

local function estadisticas(player_name)
    local sorted_stats = {}
    local player_kills = kills[player_name] or 0
    local player_deaths = deaths[player_name] or 0

    for player, kill_count in pairs(kills) do
        local death_count = deaths[player] or 0
        local function calcular_kd(kills, deaths)
            local kd_ratio = death_count > 0 and (kill_count / death_count) or kill_count
            return math.floor(kd_ratio * 100) / 100
        end
        local kd_ratio = calcular_kd(kills, deaths)
        table.insert(sorted_stats, {
            player = player,
            kills = kill_count,
            deaths = death_count,
            kd = kd_ratio
        })
    end

    table.sort(sorted_stats, function(a, b) return a.kills > b.kills end)

    for position, entry in ipairs(sorted_stats) do
        entry.position = position
    end
    local player_position = nil
    for _, stats in ipairs(sorted_stats) do
        if stats.player == player_name then
            player_position = stats.position
            break
        end
    end

    local d_ = {}
    for _, stats in pairs(sorted_stats) do 
        table.insert(d_, {
            stats.position, 
            stats.player,
            stats.kills,
            stats.deaths,
            stats.kd,
        })
    end
    
    local form = [[
        size[10,8]
        label[4,0;Top players]
        background[-0.25,-0.25;10.75,8.75;pvp_center_background.png]
        tablecolumns[text,align=center,padding=0;text,align=center,padding=5;text,align=center,padding=5;text,align=center,padding=5;text,align=center,padding=3]
        button_exit[7,6.5;2,1;exit;exit]
        table[0.4,0.5;9,6;stats_text;,Player,Kills,Deaths,K/D,]]
    
    for _, d in pairs(d_) do
        form = form .. table.concat(d, ",") .. ((d_[1+_] and ",") or "")
    end

    form = form .. ((d_[1] and ",") or "") .. "]"

    if player_position then
        form = form .. "label[4,7;Your Position: " .. player_position .. "]"
    else
        form = form .. "label[4,7;Your Position: Not Found]"
    end

    minetest.show_formspec(player_name, "stats:ranking", form)
end

minetest.register_chatcommand("top", {
    description = "Muestra el ranking de jugadores.",
    func = function(name)
        estadisticas(name) 
    end,
})
local function stats(player_name)
    local kills = kills[player_name] or 0
    local deaths = deaths[player_name] or 0
    local function calcular_kd(kills, deaths)
        local kd_ratio = deaths > 0 and (kills / deaths) or kills
        return math.floor(kd_ratio * 100) / 100
    end
    local kd = calcular_kd(kills, deaths)
    local mensaje = minetest.colorize("#00FF00","Kill: " .. kills .. "\nDeaths: " .. deaths.. "\nKd: " .. kd)
    minetest.chat_send_player(player_name,mensaje)
end

cargar_estaditicas_archivo()

minetest.register_on_shutdown(function()
    guardar_estaditicas_archivo()
end)

minetest.register_chatcommand("stats", {
    desc = "Muestra tus estadísticas",
    params = "",
    func = function(name, param)
        stats(name)
        return true
    end
})


local function auto_save()
    guardar_estaditicas_archivo()
end

minetest.register_globalstep(function(dtime)
    if not tiempo then
        tiempo = 0
    end
    tiempo = tiempo + dtime
    if tiempo >= tiempo_para_guardar then
        auto_save()
        tiempo = 0 
    end
end)